/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractBoxGenerator;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorState;
import de.lwsystems.mailarchive.archive.box.FSHexBennoBox;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.journal.ClosedBoxJournalEntry;
import de.lwsystems.mailarchive.config.AbstractFSBoxConfig;
import de.lwsystems.mailarchive.config.IBoxConfig;
import de.lwsystems.mailarchive.config.IFSBoxConfig;
import de.lwsystems.mailarchive.config.IFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.DocumentAlreadyArchivedException;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.File;
import org.apache.log4j.Logger;

public abstract class AbstractMultiFSBoxGenerator
extends AbstractBoxGenerator {
    private static final Logger LOGGER = Logger.getLogger(AbstractMultiFSBoxGenerator.class);
    private final boolean readOnly;

    public AbstractMultiFSBoxGenerator(IBoxHolder boxHolder, IFSBoxGeneratorConfig config, boolean readOnly) throws ArchiveException {
        super(boxHolder, AbstractMultiFSBoxGenerator.getBoxGeneratorState(config));
        this.readOnly = readOnly;
    }

    private static BoxGeneratorState getBoxGeneratorState(IFSBoxGeneratorConfig config) {
        BoxGeneratorState state = null;
        File boxStateFile = new File(config.getBox().getDirectory() + File.separator + "boxstate.xml");
        if (boxStateFile.exists() && boxStateFile.canRead()) {
            try {
                state = (BoxGeneratorState)BoxGeneratorState.getPersister().read(BoxGeneratorState.class, boxStateFile);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error reading boxstate in \"" + boxStateFile.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
        if (state == null) {
            state = new BoxGeneratorState(config.getBox());
        }
        return state;
    }

    protected void saveState() throws ArchiveException {
        BoxGeneratorState state = this.getState();
        if (state != null) {
            AbstractFSBoxConfig config = (AbstractFSBoxConfig)state.getConfig();
            File directory = new File(config.directory);
            if (!directory.exists()) {
                if (this.readOnly) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" does not exist.");
                }
                if (!directory.mkdirs()) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" canot be created.");
                }
                if (!directory.exists()) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" canot be created.");
                }
            }
            if (!directory.isDirectory()) {
                throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" is not a directory.");
            }
            if (!this.readOnly && !directory.canWrite()) {
                throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" is not a writeable.");
            }
            File boxStateFile = new File(config.directory + File.separator + "boxstate.xml");
            try {
                BoxGeneratorState.getPersister().write((Object)state, boxStateFile);
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)("Error writing boxstate to \"" + boxStateFile.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
    }

    protected abstract String getActualBoxName();

    private synchronized IBox getCurrentBox() throws ArchiveException {
        IBox box = null;
        if (!this.readOnly) {
            String boxName = this.getActualBoxName();
            if (boxName.equals(this.getState().getActualBoxName())) {
                box = this.getState().getActualBox();
            } else {
                IBox oldBox = this.getState().getActualBox();
                String oldHash = null;
                if (oldBox != null) {
                    oldHash = oldBox.closeBox();
                    box = this.getBox((AbstractFSBoxConfig)this.getState().getConfig(), this.getBoxHolder(), boxName, this.isReadOnly());
                    box.getJournal().addEntry(new ClosedBoxJournalEntry(oldBox.getIdentifier(), oldHash));
                } else {
                    box = this.getBox((AbstractFSBoxConfig)this.getState().getConfig(), this.getBoxHolder(), boxName, this.isReadOnly());
                }
                this.getState().setActualBox(box);
                this.saveState();
            }
        }
        return box;
    }

    public IBox getBox(IBoxConfig boxConfig, IBoxHolder boxHolder, String identifier, boolean readOnly) throws ArchiveException {
        FSHexBennoBox box = null;
        if (boxConfig instanceof IFSBoxConfig) {
            IFSBoxConfig fsBoxConfig = (IFSBoxConfig)boxConfig;
            switch (fsBoxConfig.getFSBoxType()) {
                case HEX_BENNO: {
                    box = new FSHexBennoBox(boxHolder, fsBoxConfig, identifier, readOnly);
                    break;
                }
            }
        }
        return box;
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException, DocumentAlreadyArchivedException {
        DocumentId docid = null;
        if (this.isReadOnly()) {
            throw new FailedArchivingException(document, "Archive \"" + this.getArchive().getIdentifier() + "\" is readonly");
        }
        try {
            IBox box = this.getCurrentBox();
            docid = box.addDocument(document);
            docid.setInternalId(box.getIdentifier());
        }
        catch (ArchiveException ex) {
            throw new FailedArchivingException(document, ex);
        }
        return docid;
    }

    @Override
    public DocumentId getDocument(MailDocument document) {
        DocumentId docid = null;
        try {
            IBox box = this.getCurrentBox();
            docid = box.getDocument(document);
            docid.setInternalId(box.getIdentifier());
        }
        catch (ArchiveException e) {
            return null;
        }
        return docid;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

