/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.journal;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.journal.DailyFSJournal;
import de.lwsystems.mailarchive.archive.journal.FSJournal;
import de.lwsystems.mailarchive.archive.journal.IJournal;
import de.lwsystems.mailarchive.archive.journal.MonthlyFSJournal;
import de.lwsystems.mailarchive.archive.journal.QuarterlyFSJournal;
import de.lwsystems.mailarchive.archive.journal.WeeklyFSJournal;
import de.lwsystems.mailarchive.config.DailyFSJournalConfig;
import de.lwsystems.mailarchive.config.FSJournalConfig;
import de.lwsystems.mailarchive.config.xml.MonthlyFSJournalConfig;
import de.lwsystems.mailarchive.config.xml.QuarterlyFSJournalConfig;
import de.lwsystems.mailarchive.config.xml.WeeklyFSJournalConfig;
import java.io.File;

public class JournalFactory {
    public static IJournal createFSJournal(IBox box, FSJournalConfig config, File directory, boolean readOnly) throws ArchiveException {
        FSJournal journal = null;
        switch (config.getType()) {
            case DAILY: {
                journal = new DailyFSJournal(box, (DailyFSJournalConfig)config, directory, readOnly);
                break;
            }
            case MONTHLY: {
                journal = new MonthlyFSJournal(box, (MonthlyFSJournalConfig)config, directory, readOnly);
                break;
            }
            case QUARTERLY: {
                journal = new QuarterlyFSJournal(box, (QuarterlyFSJournalConfig)config, directory, readOnly);
                break;
            }
            case SINGLE: {
                journal = new FSJournal(box, config, directory, readOnly);
                break;
            }
            case WEEKLY: {
                journal = new WeeklyFSJournal(box, (WeeklyFSJournalConfig)config, directory, readOnly);
                break;
            }
            default: {
                throw new RuntimeException("bad configuration");
            }
        }
        return journal;
    }
}

