/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailservice;

import de.lwsystems.mailarchive.config.IDirectoryWatchConfig;
import de.lwsystems.mailarchive.config.IFileParserConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocumentListener;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.IMailListener;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.mailservice.IMailService;
import de.lwsystems.mailarchive.parser.AbstractStreamFileParser;
import de.lwsystems.mailarchive.parser.BennoMailfileParser;
import de.lwsystems.mailarchive.parser.IFileParser;
import de.lwsystems.mailarchive.parser.MailfileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DirectoryWatchService
implements IMailService,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(DirectoryWatchService.class);
    public static long WATCHINTERVALL = 5000L;
    private static final long MAXFILES = 500L;
    protected static final String ERRORSUFFIX = ".err";
    protected static final String PROCESSINGSUFFIX = ".processing";
    private final IFileParser fileParser;
    private final File directory;
    private final String pattern;
    private BennoFileProcessor fileProcessor = new BennoFileProcessor();
    private Thread myThread;
    protected List<IMailListener> listeners = new ArrayList<IMailListener>();
    protected volatile boolean running = false;
    protected volatile boolean starting = false;
    private boolean destroyed = false;

    public DirectoryWatchService(String directory, String pattern) {
        this(new File(directory), pattern, new MailfileParser());
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public synchronized void destroy() {
        this.destroyed = true;
        this.stop();
        IMailListener[] listeners = new IMailListener[this.listeners.size()];
        for (IMailListener listener : listeners = this.listeners.toArray(listeners)) {
            this.removeMailListener(listener);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isStarting() {
        return this.starting;
    }

    @Override
    public void addMailListener(IMailListener listener) {
        if (!this.isDestroyed() && listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeMailListener(IMailListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
            listener.shutdown();
        }
    }

    protected boolean deliverMail(MailDocument mail) {
        boolean successful = true;
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    DocumentId documentId = listener.addDocument(mail);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info((Object)("Email archived as " + documentId.getFullDocumentId()));
                }
                catch (NonFailingArchivingException ex) {
                    mail.indexingFinished();
                }
                catch (FailedArchivingException ex) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("Problem archiving email " + ex));
                    }
                    successful = false;
                }
            }
        } else {
            successful = false;
        }
        return successful;
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public synchronized void start() {
        if (!this.isDestroyed()) {
            if (!this.starting) {
                this.starting = true;
            }
            if (this.myThread == null || !this.myThread.isAlive()) {
                this.myThread = new Thread((Runnable)this, this.getIdentifier());
                this.myThread.setDaemon(false);
            }
            if (this.myThread != null && !this.myThread.isAlive()) {
                this.myThread.start();
            }
        }
    }

    public Thread getThread() {
        return this.myThread;
    }

    @Override
    public synchronized void stop() {
        if (this.starting) {
            this.starting = false;
        }
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.starting) {
                this.running = true;
                this.doRun();
            }
        }
        catch (Exception ex) {
            this.starting = false;
            LOGGER.log((Priority)Level.ERROR, (Object)("Exception in Thread " + this.getIdentifier()), (Throwable)ex);
        }
        finally {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        DirectoryWatchService directoryWatchService = this;
        synchronized (directoryWatchService) {
            this.notify();
        }
        for (IMailListener l : this.listeners) {
            l.shutdown();
        }
    }

    @Override
    public String getState() {
        String state = this.starting ? (this.myThread != null && this.myThread.isAlive() ? "running" : "starting") : (this.myThread != null && this.myThread.isAlive() ? "stopping" : "stopped");
        return state;
    }

    public DirectoryWatchService(File directory, String pattern, IFileParser fileParser) {
        this.directory = directory;
        if (this.directory == null) {
            throw new IllegalArgumentException("Directory must not be empty");
        }
        if (!this.directory.exists()) {
            throw new IllegalArgumentException("\"" + directory.getAbsolutePath() + "\" does not exist");
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("\"" + directory.getAbsolutePath() + "\" is not a directory");
        }
        if (!this.directory.canRead()) {
            throw new IllegalArgumentException("Directory \"" + directory.getAbsolutePath() + "\" is not readable");
        }
        this.pattern = pattern == null || pattern.length() == 0 ? ".*" : pattern;
        if (fileParser == null) {
            throw new IllegalArgumentException("Fileparser must not be empty");
        }
        this.fileParser = fileParser;
    }

    public DirectoryWatchService(IDirectoryWatchConfig config) {
        this.directory = new File(config.getDirectory());
        this.pattern = config.getPattern();
        this.fileParser = this.createFileParser(config.getParser());
    }

    private IFileParser createFileParser(IFileParserConfig parser) {
        AbstractStreamFileParser fileParser = null;
        switch (parser.getType()) {
            case BENNO: {
                fileParser = new BennoMailfileParser(parser);
                break;
            }
            case MAILFILE: {
                fileParser = new MailfileParser(parser);
                break;
            }
            default: {
                throw new RuntimeException("bad configuration");
            }
        }
        return fileParser;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && obj instanceof DirectoryWatchService) {
            equal = this.directory.equals(((DirectoryWatchService)obj).directory) && this.pattern.equals(((DirectoryWatchService)obj).pattern);
        }
        return equal;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.directory != null ? this.directory.hashCode() : 0);
        hash = 97 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws Exception {
        while (this.starting) {
            long waitTime = System.currentTimeMillis() + WATCHINTERVALL;
            try {
                this.UpdateDirectory();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                LOGGER.error((Object)ex);
            }
            waitTime -= System.currentTimeMillis();
            DirectoryWatchService directoryWatchService = this;
            synchronized (directoryWatchService) {
                if (waitTime > 0L && waitTime < WATCHINTERVALL) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public String getIdentifier() {
        return "Directory watcher \"" + this.directory.getAbsolutePath() + "\"" + File.separator + "\"" + this.pattern + "\"";
    }

    private void UpdateDirectory() {
        if (this.directory == null) {
            throw new IllegalArgumentException("Directory became null, stopping directorywatcher");
        }
        String[] files = this.directory.list(new FilenameFilter(){
            private int count = 0;

            @Override
            public boolean accept(File dir, String name) {
                if ((long)this.count < 500L && name.matches(DirectoryWatchService.this.pattern) && !name.endsWith(DirectoryWatchService.ERRORSUFFIX) && !name.endsWith(DirectoryWatchService.PROCESSINGSUFFIX) && new File(dir + File.separator + name).isFile()) {
                    ++this.count;
                    return true;
                }
                return false;
            }
        });
        if (files != null) {
            for (String filename : files) {
                if (!this.starting || filename == null) continue;
                this.fileProcessor.processFile(filename);
            }
        }
    }

    class BennoFileProcessor {
        private File renameFile(String filename) throws IOException {
            String filePath = DirectoryWatchService.this.directory.getAbsolutePath() + "/" + filename;
            File file = new File(filePath);
            File inprocessFile = new File(filePath + DirectoryWatchService.PROCESSINGSUFFIX);
            file.renameTo(inprocessFile);
            return inprocessFile;
        }

        public void processFile(String filename) {
            Date date = new Date();
            final long ts = new Timestamp(date.getTime()).getTime();
            File file = null;
            try {
                final File processedFile = file = DirectoryWatchService.this.fileProcessor.renameFile(filename);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Read file " + file.getAbsolutePath()));
                }
                MailDocument document = DirectoryWatchService.this.fileParser.parseFile(processedFile);
                document.addMailDocumentListener(new MailDocumentListener(){

                    @Override
                    public void processingCompleted() {
                        processedFile.delete();
                    }

                    @Override
                    public void processingError(Exception ex) {
                        LOGGER.error((Object)("Error processing file \"" + processedFile.getAbsolutePath() + "\""), (Throwable)ex);
                        processedFile.renameTo(new File(processedFile.getAbsolutePath() + "-" + String.valueOf(ts) + DirectoryWatchService.ERRORSUFFIX));
                    }
                });
                if (DirectoryWatchService.this.deliverMail(document)) {
                    document.deliverySuccessful();
                } else {
                    LOGGER.warn((Object)("Problem archiving email file " + file.getAbsolutePath()));
                    file.renameTo(new File(file.getAbsolutePath() + "-" + String.valueOf(ts) + DirectoryWatchService.ERRORSUFFIX));
                }
            }
            catch (FileNotFoundException ex) {
                LOGGER.error((Object)"Listed file not found (had been removed before it could be read", (Throwable)ex);
            }
            catch (ParserException ex) {
                LOGGER.error((Object)("Error parsing file \"" + file.getAbsolutePath() + "\""), (Throwable)ex);
                file.renameTo(new File(file.getAbsolutePath() + "-" + String.valueOf(ts) + DirectoryWatchService.ERRORSUFFIX));
            }
            catch (IOException ex) {
                LOGGER.error((Object)"File could not be moved", (Throwable)ex);
            }
        }
    }
}

