/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailfile;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.BennoBox;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.config.BoxConfig;
import de.lwsystems.mailarchive.config.FSBoxStorageConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.mailfile.IMailFile;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FSMailFile
implements IMailFile {
    private MailDocumentId documentId;

    public FSMailFile(MailDocumentId documentId) {
        this.documentId = documentId;
    }

    @Override
    public void createMailFile(MailDocument document, IBox iBox, boolean readOnly) throws FailedArchivingException, ArchiveException {
        BoxConfig boxConfig = this.createTempBoxConfig(iBox);
        boxConfig.setBoxStorageConfig(this.createTempFsBoxStorageConfig());
        BennoBox bennoBox = new BennoBox(iBox.getBoxHolder(), boxConfig, iBox.getRepoPath(), readOnly);
        bennoBox.saveDocument(document, this.documentId);
    }

    @Override
    public void deleteMailFile(String repoPath) throws IOException, InvalidPathException {
        FSBoxStorageConfig boxStorageConfig = new FSBoxStorageConfig();
        boxStorageConfig.setDriver("fs");
        Path filePath = Paths.get(File.separator + repoPath + File.separator + this.documentId.getInternalBoxIndentifier() + File.separator + this.documentId.getHashHex() + this.documentId.getDuplicateIdHex() + CompressionUtil.getCompressionSuffix(IBox.CompressionType.none), new String[0]);
        Files.deleteIfExists(filePath);
    }

    private BoxConfig createTempBoxConfig(IBox iBox) {
        BoxConfig boxConfig = new BoxConfig();
        boxConfig.setJournalConfig(iBox.getBoxConfig().getJournalConfig());
        boxConfig.setBoxStorageConfig(iBox.getBoxConfig().getBoxStorageConfig());
        boxConfig.setIdentifier(iBox.getBoxConfig().getIdentifier());
        boxConfig.setStoragePath(iBox.getBoxConfig().getStoragePath());
        boxConfig.setCompression(IBox.CompressionType.none);
        boxConfig.setEncryption(null);
        return boxConfig;
    }

    private FSBoxStorageConfig createTempFsBoxStorageConfig() {
        FSBoxStorageConfig boxStorageConfig = new FSBoxStorageConfig();
        boxStorageConfig.setDirLength(0);
        boxStorageConfig.setSubdirs(0);
        boxStorageConfig.setDriver("fs");
        return boxStorageConfig;
    }
}

