/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.parser;

import de.lwsystems.mailarchive.config.IFileParserConfig;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.TempMailMetaData;
import de.lwsystems.mailarchive.parser.AbstractStreamFileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import de.lwsystems.mailarchive.utils.CustomHash;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MailDateFormat;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailfileParser
extends AbstractStreamFileParser {
    private static final Logger LOGGER = LogManager.getLogger(MailfileParser.class);
    private final String[] secretHeaders;
    private final String[] customHashHeaders;
    private final String[] senderHeaders;
    private final String[] recipientHeaders;
    private final String[] fromHeaders;
    private final String[] toHeaders;
    private final String[] ccHeaders;
    private boolean multipartAlternative = false;
    private boolean isSmimeMail = false;

    public MailfileParser() {
        this(new String[]{"X-REAL-MAILFROM", "RECIPIENT-FROM"}, new String[]{"X-REAL-RCPTTO", "RECIPIENT-TO", "BCC"}, new String[]{"X-REAL-MAILFROM", "RECIPIENT-FROM", "X-REAL-RCPTTO", "RECIPIENT-TO", "BCC"}, new String[0]);
    }

    public MailfileParser(String[] senderHeaders, String[] recipientHeaders, String[] secretHeaders, String[] customHashHeaders) {
        this(senderHeaders, recipientHeaders, secretHeaders, new String[]{"FROM"}, new String[]{"TO"}, new String[]{"CC"}, customHashHeaders);
    }

    public MailfileParser(String[] senderHeaders, String[] recipientHeaders, String[] secretHeaders, String[] fromHeaders, String[] toHeaders, String[] ccHeaders, String[] customHashHeaders) {
        this.secretHeaders = secretHeaders;
        this.senderHeaders = senderHeaders;
        this.recipientHeaders = recipientHeaders;
        this.fromHeaders = fromHeaders;
        this.customHashHeaders = customHashHeaders;
        this.toHeaders = toHeaders;
        this.ccHeaders = ccHeaders;
    }

    public MailfileParser(IFileParserConfig config) {
        this(config.getSenders().toArray(new String[config.getSenders().size()]), config.getRecipients().toArray(new String[config.getRecipients().size()]), config.getSecrets().toArray(new String[config.getSecrets().size()]), config.getCustomHashParameters().toArray(new String[config.getCustomHashParameters().size()]));
    }

    private boolean isIn(String single, String[] array) {
        boolean in = false;
        if (array != null) {
            for (int i = 0; !in && i < array.length; ++i) {
                in = array[i].equalsIgnoreCase(single);
            }
        }
        return in;
    }

    private void writeMail(OutputStream mail, MessageDigest md, byte singleByte) throws IOException {
        md.update(singleByte);
        mail.write(singleByte);
    }

    private void writeMail(OutputStream mail, MessageDigest md, byte[] bytes) throws IOException {
        md.update(bytes);
        mail.write(bytes);
    }

    private void processHeaderLine(TempMailMetaData tempMeta, ByteArrayOutputStream tempOutBytes, MessageDigest md, ByteArrayOutputStream tempLine) throws ParserException, UnsupportedEncodingException, IOException {
        byte[] tempInBytes = tempLine.toByteArray();
        tempLine.reset();
        if (tempInBytes.length > 0) {
            try {
                Header tempHeader = new Header(tempInBytes);
                tempMeta.addHeader(tempHeader);
                boolean headerAdded = false;
                String contentType = "mixed";
                if (!this.isIn(tempHeader.getName(), this.secretHeaders)) {
                    headerAdded = true;
                    this.writeMail((OutputStream)tempOutBytes, md, tempInBytes);
                }
                if (this.isIn(tempHeader.getName(), this.senderHeaders)) {
                    try {
                        tempMeta.addSender(tempHeader.getBody());
                        headerAdded = true;
                    }
                    catch (AddressException ex) {
                        LOGGER.error((Object)ex);
                    }
                }
                if (this.isIn(tempHeader.getName(), this.recipientHeaders)) {
                    try {
                        tempMeta.addRecipient(tempHeader.getBody());
                        headerAdded = true;
                    }
                    catch (AddressException ex) {
                        LOGGER.error((Object)ex);
                    }
                }
                if (this.isIn(tempHeader.getName(), this.fromHeaders)) {
                    try {
                        tempMeta.addFrom(tempHeader.getBody());
                        headerAdded = true;
                    }
                    catch (AddressException ex) {
                        LOGGER.error((Object)ex);
                    }
                }
                if (this.isIn(tempHeader.getName(), this.toHeaders)) {
                    try {
                        tempMeta.addTo(tempHeader.getBody());
                        headerAdded = true;
                    }
                    catch (AddressException ex) {
                        LOGGER.error((Object)ex);
                    }
                }
                if (this.isIn(tempHeader.getName(), this.ccHeaders)) {
                    try {
                        tempMeta.addCc(tempHeader.getBody());
                        headerAdded = true;
                    }
                    catch (AddressException ex) {
                        LOGGER.error((Object)ex);
                    }
                }
                if (tempHeader.getName().equalsIgnoreCase("Date")) {
                    headerAdded = true;
                    tempMeta.setDate(new MailDateFormat().parse(tempHeader.getBody()));
                    tempMeta.setTimezone(tempHeader.getBody());
                }
                if (this.isIn(tempHeader.getName(), this.customHashHeaders)) {
                    try {
                        tempMeta.addCustomHashParameter(tempHeader.getBody());
                        tempMeta.setCustomHashActive(true);
                        headerAdded = true;
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)ex);
                    }
                }
                if (tempHeader.getName().equalsIgnoreCase("Content-Type")) {
                    headerAdded = true;
                    String body = tempHeader.getBody().toLowerCase();
                    if (!body.contains(contentType)) {
                        this.multipartAlternative = true;
                    } else {
                        tempMeta.setAttached(body.contains(contentType));
                    }
                }
                if (!headerAdded) {
                    tempMeta.addSecretHeader(tempHeader);
                }
            }
            catch (Exception ex) {
                this.writeMail((OutputStream)tempOutBytes, md, tempInBytes);
                LOGGER.trace("Error while parsing the mailfile: " + ex.toString());
                tempMeta.setDefective(true);
            }
        }
    }

    @Override
    public MailDocument parseSmimeStream(InputStream stream, int length) throws ParserException {
        this.isSmimeMail = true;
        return this.parseStream(stream, length);
    }

    @Override
    public MailDocument parseStream(InputStream stream, int length) throws ParserException {
        MailDocument document = null;
        if (stream != null) {
            try {
                if (stream instanceof FileInputStream) {
                    stream = new BufferedInputStream(stream);
                }
                TempMailMetaData tempMeta = new TempMailMetaData();
                ByteArrayOutputStream tempBytes = new ByteArrayOutputStream(length);
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                try {
                    boolean inHeader = true;
                    boolean receivedNewline = false;
                    boolean processLine = false;
                    ByteArrayOutputStream tempLine = new ByteArrayOutputStream(1024);
                    int tempByte = 0;
                    tempByte = stream.read();
                    block15: while (inHeader) {
                        if (tempByte == -1) {
                            this.processHeaderLine(tempMeta, tempBytes, md, tempLine);
                            inHeader = false;
                            continue;
                        }
                        if (receivedNewline) {
                            receivedNewline = false;
                            switch (tempByte) {
                                case 10: {
                                    inHeader = false;
                                    this.processHeaderLine(tempMeta, tempBytes, md, tempLine);
                                    tempLine.write(tempByte);
                                    tempByte = stream.read();
                                    if (tempByte == 13) {
                                        tempLine.write(tempByte);
                                        tempByte = stream.read();
                                    }
                                    this.writeMail((OutputStream)tempBytes, md, tempLine.toByteArray());
                                    continue block15;
                                }
                                case 13: {
                                    inHeader = false;
                                    this.processHeaderLine(tempMeta, tempBytes, md, tempLine);
                                    tempLine.write(tempByte);
                                    tempByte = stream.read();
                                    if (tempByte == 10) {
                                        tempLine.write(tempByte);
                                        tempByte = stream.read();
                                    }
                                    this.writeMail((OutputStream)tempBytes, md, tempLine.toByteArray());
                                    continue block15;
                                }
                                case 9: 
                                case 32: {
                                    tempLine.write(tempByte);
                                    tempByte = stream.read();
                                    continue block15;
                                }
                            }
                            this.processHeaderLine(tempMeta, tempBytes, md, tempLine);
                            tempLine.write(tempByte);
                            tempByte = stream.read();
                            continue;
                        }
                        switch (tempByte) {
                            case 10: {
                                receivedNewline = true;
                                tempLine.write(tempByte);
                                tempByte = stream.read();
                                if (tempByte != 13) continue block15;
                                tempLine.write(tempByte);
                                tempByte = stream.read();
                                continue block15;
                            }
                            case 13: {
                                receivedNewline = true;
                                tempLine.write(tempByte);
                                tempByte = stream.read();
                                if (tempByte != 10) continue block15;
                                tempLine.write(tempByte);
                                tempByte = stream.read();
                                continue block15;
                            }
                        }
                        tempLine.write(tempByte);
                        tempByte = stream.read();
                    }
                    if (tempByte != -1) {
                        this.writeMail((OutputStream)tempBytes, md, (byte)tempByte);
                        byte[] mailBodyBytes = IOUtils.toByteArray((InputStream)stream);
                        this.writeMail((OutputStream)tempBytes, md, mailBodyBytes);
                    }
                    String actHash = ConversionUtil.fromBytesToHex(md.digest());
                    if (this.multipartAlternative) {
                        String fullMailBody = tempBytes.toString().toLowerCase();
                        if (fullMailBody.toLowerCase().contains("content-type: application") || fullMailBody.toLowerCase().contains("content-type: text/calendar;") || fullMailBody.toLowerCase().contains("content-disposition: attachment;") || fullMailBody.toLowerCase().contains("content-disposition: inline;")) {
                            tempMeta.setAttached(true);
                        } else {
                            tempMeta.setAttached(false);
                        }
                    }
                    if (tempMeta.isCustomHashActive()) {
                        tempMeta.setHash(CustomHash.createCustomHash(tempMeta.getMailMetaData().getCustomHashParameterList(), actHash));
                        tempMeta.setStandardChecksum(actHash);
                    } else {
                        tempMeta.setHash(actHash);
                    }
                    tempMeta.setSize(tempBytes.size());
                    document = new MailDocument(tempBytes.toByteArray(), tempMeta.getMailMetaData());
                }
                catch (IOException ex) {
                    LOGGER.error("", (Throwable)ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.error("", (Throwable)ex);
            }
            try {
                stream.close();
            }
            catch (IOException ex) {
                LOGGER.info((Object)ex);
            }
        }
        return document;
    }
}

