/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.log;

import de.lwsystems.mailarchive.log.LogClass;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class RemoveLogClass
extends LogClass {
    private static HashMap<String, LogClass> instance;
    public static final String tempFileName = "delete.tmp";
    private final String deleteFileNameSuffix = ".remove";

    private RemoveLogClass(String indexPath) throws IOException {
        boolean existsLogFile = super.existsLogFile(indexPath, tempFileName);
        if (!existsLogFile) {
        }
    }

    public static void removeAllContainerFromInstance() {
        for (Map.Entry<String, LogClass> logClass : instance.entrySet()) {
            instance.remove(logClass.getKey());
        }
    }

    public static void removeContainerFromInstance(String container) {
        instance.remove(container);
    }

    public static HashMap<String, LogClass> getInstanceList() {
        return instance;
    }

    public static LogClass getInstance(String container, String indexPath) throws IOException {
        if (instance == null) {
            instance = new HashMap();
        }
        if (instance.get(container) == null) {
            instance.put(container, new RemoveLogClass(indexPath));
        }
        return instance.get(container);
    }

    @Override
    public void moveLogFile() throws IOException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String path = this.logFileDirectory.normalize().toString() + "/" + timestamp.getTime() + ".remove";
        Path newLogFilePath = Paths.get(path, new String[0]);
        super.moveFile(newLogFilePath);
    }

    @Override
    public void addEntry(String ... logFileText) throws IOException {
        for (String text : logFileText) {
            Files.write(this.logFilePath, text.getBytes(), StandardOpenOption.APPEND);
            Files.write(this.logFilePath, this.lineBreak.getBytes(), StandardOpenOption.APPEND);
        }
    }
}

