/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.config.BoxEncryption;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;

public class CryptoUtils {
    public static String createEncryptionKey(BoxEncryption.BoxEncryptionEngine engine) {
        SecretKey key = CryptoUtils.createKey(engine.getEngine(), engine.getKeySize());
        return new String(new Base64().encode(key.getEncoded()));
    }

    public static InputStream encryptStream(InputStream in, BoxEncryption.BoxEncryptionEngine engine, PublicKey publicKey) throws GeneralSecurityException, IOException {
        byte[] ivByte = CryptoUtils.randomBytes(16);
        byte[] key = CryptoUtils.randomBytes(32);
        byte[] stringToEncrypt = CryptoUtils.concat(key, ivByte);
        byte[] encryptedData = CryptoUtils.encrypt(stringToEncrypt, publicKey);
        Cipher encryptCipher = CryptoUtils.makeCipher(engine, ivByte, key, 1);
        List<InputStream> streams = Arrays.asList(new ByteArrayInputStream(encryptedData), new CipherInputStream(in, encryptCipher));
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public static CipherOutputStream encryptStream(OutputStream out, BoxEncryption.BoxEncryptionEngine engine, PublicKey publicKey) throws GeneralSecurityException, IOException {
        byte[] ivByte = CryptoUtils.randomBytes(16);
        byte[] key = CryptoUtils.randomBytes(32);
        byte[] stringToEncrypt = CryptoUtils.concat(key, ivByte);
        byte[] encryptedData = CryptoUtils.encrypt(stringToEncrypt, publicKey);
        Cipher encryptCipher = CryptoUtils.makeCipher(engine, ivByte, key, 1);
        out.write(encryptedData);
        return new CipherOutputStream(out, encryptCipher);
    }

    private static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    private static byte[] randomBytes(int size) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[size];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    public static CipherInputStream decryptStream(InputStream in, BoxEncryption.BoxEncryptionEngine engine, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        int blocksize = engine.getBlockSize(privateKey);
        byte[] encryptedKeyAndIv = new byte[blocksize];
        int read = in.read(encryptedKeyAndIv);
        if (read != blocksize) {
            throw new IllegalArgumentException();
        }
        Cipher cipher = CryptoUtils.makeSymetricDecryptCipher(engine, privateKey, encryptedKeyAndIv);
        return new CipherInputStream(in, cipher);
    }

    private static Cipher makeSymetricDecryptCipher(BoxEncryption.BoxEncryptionEngine engine, PrivateKey privateKey, byte[] encryptedKeyAndIv) throws IOException, GeneralSecurityException {
        byte[] rawData = CryptoUtils.decrypt(encryptedKeyAndIv, privateKey);
        byte[] ivByte = new byte[16];
        System.arraycopy(rawData, 32, ivByte, 0, 16);
        byte[] key = new byte[32];
        System.arraycopy(rawData, 0, key, 0, 32);
        return CryptoUtils.makeCipher(engine, ivByte, key, 2);
    }

    private static Cipher makeCipher(BoxEncryption.BoxEncryptionEngine engine, byte[] ivByte, byte[] key, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(engine.getCipher());
        IvParameterSpec ivParamsSpec = new IvParameterSpec(ivByte);
        cipher.init(mode, CryptoUtils.keyFromString(engine, key), ivParamsSpec);
        return cipher;
    }

    public static byte[] encrypt(byte[] rawText, PublicKey publicKey) throws IOException, GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return cipher.doFinal(rawText);
    }

    public static byte[] decrypt(byte[] cipherText, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return cipher.doFinal(cipherText);
    }

    private static Key keyFromString(BoxEncryption.BoxEncryptionEngine engine, byte[] key) {
        return new SecretKeySpec(key, 0, key.length, engine.getEngine());
    }

    private static SecretKey createKey(String engine, int keySize) {
        KeyGenerator kgen;
        try {
            kgen = KeyGenerator.getInstance(engine);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SecureRandom rand = new SecureRandom();
        kgen.init(keySize, rand);
        return kgen.generateKey();
    }

    public static KeyPair loadKeyPair(String privateKeyFile, String privateKeyFilePassword) throws IOException {
        return CryptoUtils.loadKeyPair(new FileReader(privateKeyFile), privateKeyFilePassword);
    }

    public static KeyPair loadKeyPair(Reader reader, String password) throws IOException {
        return CryptoUtils.getKeyPair(reader);
    }

    private static String getKey(Reader reader) throws IOException {
        String line;
        Object strKeyPEM = "";
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            strKeyPEM = (String)strKeyPEM + line + "\n";
        }
        br.close();
        return strKeyPEM;
    }

    public static RSAPublicKeySpec getPublicKeySpec(PrivateKey priv) {
        RSAPrivateCrtKey rsaCrtKey = (RSAPrivateCrtKey)priv;
        return new RSAPublicKeySpec(rsaCrtKey.getModulus(), rsaCrtKey.getPublicExponent());
    }

    public static KeyPair getKeyPair(Reader reader) throws IOException {
        String privateKeyPEM = CryptoUtils.getKey(reader);
        try {
            return CryptoUtils.getKeyPair(privateKeyPEM);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static KeyPair getKeyPair(String key) throws IOException, GeneralSecurityException {
        String privateKeyPEM = key.replace("-----BEGIN RSA PRIVATE KEY-----\n", "").replace("-----END RSA PRIVATE KEY-----", "").replace("-----BEGIN PRIVATE KEY-----\n", "").replace("-----END PRIVATE KEY-----", "");
        byte[] encoded = Base64.decodeBase64((String)privateKeyPEM);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        RSAPrivateKey privKey = (RSAPrivateKey)kf.generatePrivate(keySpec);
        return new KeyPair(kf.generatePublic(CryptoUtils.getPublicKeySpec(privKey)), privKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadedKeyStore loadKeyStore(InputStream is, String password, String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        final KeyStore keystore = KeyStore.getInstance(keyStoreType);
        try {
            keystore.load(is, null == password ? null : password.toCharArray());
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
        return new LoadedKeyStore(){

            @Override
            public KeyPair getKeyPair(String keyAlias, String keyPassword) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
                return CryptoUtils.getKeyPair(keystore, keyAlias, keyPassword);
            }
        };
    }

    private static KeyPair getKeyPair(KeyStore keystore, String alias, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        Key key = keystore.getKey(alias, password.toCharArray());
        Certificate cert = keystore.getCertificate(alias);
        PublicKey publicKey = cert.getPublicKey();
        return new KeyPair(publicKey, (PrivateKey)key);
    }

    public static PrivateKey loadPrivateKey(Reader reader) throws IOException, GeneralSecurityException {
        PrivateKey key = null;
        BufferedReader br = new BufferedReader(reader);
        StringBuilder builder = new StringBuilder();
        boolean inKey = false;
        String line = br.readLine();
        while (line != null) {
            if (!inKey) {
                if (line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----")) {
                    inKey = true;
                }
            } else {
                if (line.startsWith("-----END ") && line.endsWith(" PRIVATE KEY-----")) {
                    inKey = false;
                    break;
                }
                builder.append(line);
            }
            line = br.readLine();
        }
        byte[] encoded = DatatypeConverter.parseBase64Binary((String)builder.toString());
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        key = kf.generatePrivate(keySpec);
        return key;
    }

    public static interface LoadedKeyStore {
        public KeyPair getKeyPair(String var1, String var2) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException;
    }
}

