/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.AbstractMapArchiveGenerator;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.ContainerArchive;
import de.lwsystems.mailarchive.config.ConfiguredArchiveGeneratorConfig;
import de.lwsystems.mailarchive.config.ContainerArchiveConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfiguredArchiveGenerator
extends AbstractMapArchiveGenerator {
    private static final Logger LOGGER = LogManager.getLogger(ConfiguredArchiveGenerator.class);
    private final boolean readOnly;

    public ConfiguredArchiveGenerator(Benno benno, ConfiguredArchiveGeneratorConfig config, boolean readOnly) {
        super(benno);
        this.readOnly = readOnly;
        this.updateArchives(config, readOnly);
    }

    private void updateArchives(ConfiguredArchiveGeneratorConfig config, boolean readOnly) {
        HashSet<String> unconfiguredArchives = new HashSet<String>();
        unconfiguredArchives.addAll(this.getArchiveMap().keySet());
        for (ContainerArchiveConfig archiveConfig : config.getArchives()) {
            try {
                String identifier = archiveConfig.getIdentifier();
                if (this.getArchiveMap().containsKey(identifier)) {
                    unconfiguredArchives.remove(identifier);
                    IArchive archive = this.getArchiveMap().get(identifier);
                    archive.configure(archiveConfig);
                    continue;
                }
                this.addArchive(identifier, this.getArchive(archiveConfig, this.getBenno(), readOnly));
            }
            catch (ArchiveException ex) {
                LOGGER.error((Object)ex);
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex);
                throw new RuntimeException(ex);
            }
        }
        for (String identifier : unconfiguredArchives) {
            IArchive archive = this.getArchiveMap().get(identifier);
            archive.close();
            this.removeArchive(identifier);
        }
    }

    private IArchive getArchive(ContainerArchiveConfig archiveConfig, Benno benno, boolean readOnly) throws ArchiveException, IOException {
        if (archiveConfig instanceof ContainerArchiveConfig) {
            ContainerArchiveConfig containerArchiveConfig = archiveConfig;
            return new ContainerArchive(benno, containerArchiveConfig, readOnly);
        }
        throw new RuntimeException("bad configuration");
    }

    @Override
    public boolean doesMatch(MailDocument document) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean updateIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rebuildIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkIntegrity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkConsistency() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean optimizeIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean optimizeRepository() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void configure(ConfiguredArchiveGeneratorConfig config) {
        this.updateArchives(config, this.readOnly);
    }

    @Override
    public void addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

