/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.PermissionDeniedException;
import de.lwsystems.mailarchive.archive.RuntimeArchiveException;
import de.lwsystems.mailarchive.archive.box.BoxState;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.journal.ArchivingFailedEntry;
import de.lwsystems.mailarchive.archive.journal.DuplicateDocumentEntry;
import de.lwsystems.mailarchive.archive.journal.IJournal;
import de.lwsystems.mailarchive.archive.journal.JournalFactory;
import de.lwsystems.mailarchive.archive.journal.RemoveIndexDocumentEntry;
import de.lwsystems.mailarchive.archive.journal.RemoveRepoDocumentEntry;
import de.lwsystems.mailarchive.archive.journal.SuccessfullyArchivedEntry;
import de.lwsystems.mailarchive.archive.storage.BoxStorageEngine;
import de.lwsystems.mailarchive.archive.storage.IBennoStorage;
import de.lwsystems.mailarchive.archive.storage.IS3BennoStorage;
import de.lwsystems.mailarchive.config.BennoStorageConfig;
import de.lwsystems.mailarchive.config.BoxConfig;
import de.lwsystems.mailarchive.config.BoxEncryption;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.mailfile.FSMailFile;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.parser.BennoMailfileParser;
import de.lwsystems.mailarchive.parser.MailfileParser;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import de.lwsystems.mailarchive.utils.CryptoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BennoBox
implements IBox {
    private static final Logger LOGGER = LogManager.getLogger(BennoBox.class);
    private final IBoxHolder boxHolder;
    private final IJournal journal;
    private final boolean readOnly;
    private final BoxConfig config;
    private IBennoStorage storage;
    private final String baseDirectory;
    private final File directory;
    private KeyPair keyPair;

    public BennoBox(IBoxHolder boxHolder, BoxConfig config, String baseDirectory, boolean readOnly) throws ArchiveException {
        this.readOnly = readOnly;
        this.boxHolder = boxHolder;
        this.config = config;
        String identifier = config.getIdentifier();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Opening Box: " + identifier + " in " + baseDirectory);
        }
        File boxRepositoryDirectory = Paths.get(baseDirectory, identifier).toFile();
        this.baseDirectory = baseDirectory;
        this.directory = boxRepositoryDirectory;
        this.createBoxStorage(this.directory, identifier, "");
        this.configureEncryption(config.getEncryption());
        this.journal = readOnly ? null : JournalFactory.createFSJournal(this, config.getJournalConfig(), new File(boxRepositoryDirectory + File.separator + "journal"), readOnly);
    }

    private void configureEncryption(BoxEncryption encryption) throws ConfigurationException {
        if (encryption != null) {
            try {
                this.keyPair = CryptoUtils.loadKeyStore(new FileInputStream(encryption.getPrivateKeyFile()), encryption.getPrivateKeyFilePassword(), encryption.getKeyStoreType()).getKeyPair(encryption.getKeyAlias(), encryption.getKeyPassword());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new ConfigurationException(this.boxHolder, e);
            }
        }
    }

    private void createBoxStorage(File directory, String identifier, String scid) {
        BennoStorageConfig boxStorageConfig = this.config.getBoxStorageConfig();
        this.storage = BoxStorageEngine.createBoxStorage(this.config, boxStorageConfig, directory, identifier);
    }

    private IBennoStorage createAndReturnBoxStorage(File directory, String identifier) {
        BennoStorageConfig boxStorageConfig = this.config.getBoxStorageConfig();
        return BoxStorageEngine.createBoxStorage(this.config, boxStorageConfig, directory, identifier);
    }

    @Override
    public BoxConfig getBoxConfig() {
        return this.config;
    }

    @Override
    public String getIdentifier() {
        return this.config.getIdentifier();
    }

    @Override
    public IBoxHolder getBoxHolder() {
        return this.boxHolder;
    }

    private File getScidPath(String scidIdentifier, String identifier) {
        return Paths.get(this.baseDirectory + File.separator + scidIdentifier, identifier).toFile();
    }

    private IJournal getScidJournal(File scidPath) throws ArchiveException {
        return JournalFactory.createFSJournal(this, this.config.getJournalConfig(), new File(scidPath + File.separator + "journal"), this.readOnly);
    }

    @Override
    public String getRepoPath() {
        return this.baseDirectory;
    }

    @Override
    public ArchivedMailDocument addDocument(MailDocument document, Map<String, BoxState> boxes) throws FailedArchivingException, ArchiveException {
        MailDocumentId[] sameHashConflicts = this.getSameHashConflicts(document, boxes);
        File scidPath = null;
        for (MailDocumentId previousMailId : sameHashConflicts) {
            try {
                Boolean equalsBenno = document.equalsBenno(this.getInputStream(previousMailId));
                if (!equalsBenno.booleanValue() && (equalsBenno.booleanValue() || !document.getMetaData().customHashActive())) continue;
                if (!document.getMetaData().getScid().equals("")) {
                    scidPath = this.getScidPath(document.getMetaData().getScid(), this.getIdentifier());
                    this.createBoxStorage(scidPath, this.getIdentifier(), document.getMetaData().getScid());
                    IJournal sidJournal = this.getScidJournal(scidPath);
                    sidJournal.addEntry(new DuplicateDocumentEntry(document, previousMailId.toString()));
                } else {
                    this.getJournal().addEntry(new DuplicateDocumentEntry(document, previousMailId.toString()));
                    this.createBoxStorage(this.directory, this.getIdentifier(), document.getMetaData().getScid());
                }
                LOGGER.warn("Document is already archived: " + previousMailId.toString());
                return new ArchivedMailDocument(document, previousMailId);
            }
            catch (FileNotFoundException ex) {
                LOGGER.error("Directory listed mailfile vanished", (Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.error("Directory listed mailfile not readable", (Throwable)ex);
            }
            catch (PermissionDeniedException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        if (!document.getMetaData().getScid().equals("")) {
            scidPath = this.getScidPath(document.getMetaData().getScid(), this.getIdentifier());
            this.createBoxStorage(scidPath, this.getIdentifier(), document.getMetaData().getScid());
        } else {
            this.createBoxStorage(this.directory, this.getIdentifier(), document.getMetaData().getScid());
        }
        int sameHashDuplicateNumber = sameHashConflicts.length > 0 ? sameHashConflicts.length : 0;
        MailDocumentId documentId = this.createMailDocumentId(document, sameHashDuplicateNumber, this.getIdentifier(), document.getMetaData().getScid());
        this.saveDocument(document, documentId);
        ArchivedMailDocument archivedMailDocument = new ArchivedMailDocument(document, documentId);
        if (!document.getMetaData().getScid().equals("")) {
            IJournal sidJournal = this.getScidJournal(scidPath);
            sidJournal.addEntry(new SuccessfullyArchivedEntry(archivedMailDocument));
        } else {
            this.addJournalEntry(archivedMailDocument);
        }
        return archivedMailDocument;
    }

    @Override
    public RemovedMailDocument removeDocument(MailDocument bennoId, Map<String, BoxState> boxes) {
        MailDocumentId[] sameHashConflicts = this.getSameHashConflicts(bennoId, boxes);
        RemovedMailDocument removedMailDocument = null;
        for (MailDocumentId mailDocumentId : sameHashConflicts) {
            try {
                removedMailDocument = new RemovedMailDocument(bennoId, mailDocumentId);
                this.getJournal().addEntry(new RemoveIndexDocumentEntry(removedMailDocument));
            }
            catch (PermissionDeniedException e) {
                throw new RuntimeException(e);
            }
        }
        return removedMailDocument;
    }

    @Override
    public void addRemoveRepoJournalEntry(RemovedMailDocument myDoc) {
        try {
            this.getJournal().addEntry(new RemoveRepoDocumentEntry(myDoc));
        }
        catch (PermissionDeniedException e) {
            throw new RuntimeException(e);
        }
    }

    private MailDocumentId[] getSameHashConflicts(MailDocument document, Map<String, BoxState> boxes) {
        int duplicateId = 0;
        ArrayList<MailDocumentId> ids = new ArrayList<MailDocumentId>();
        for (String tempBox : boxes.keySet()) {
            File boxRepositoryDirectory = !document.getMetaData().getScid().equals("") ? this.getScidPath(document.getMetaData().getScid(), tempBox) : Paths.get(this.baseDirectory, tempBox).toFile();
            BennoStorageConfig boxStorageConfig = this.config.getBoxStorageConfig();
            if (!boxRepositoryDirectory.exists()) continue;
            IBennoStorage tempStorage = BoxStorageEngine.createBoxStorage(this.config, boxStorageConfig, boxRepositoryDirectory, tempBox);
            while (tempStorage.hasDocument(this.createMailDocumentId(document, duplicateId, tempBox, document.getMetaData().getScid()), this.config.getCompression())) {
                ids.add(this.createMailDocumentId(document, duplicateId, tempBox, document.getMetaData().getScid()));
                this.createBoxStorage(boxRepositoryDirectory, tempBox, document.getMetaData().getScid());
                ++duplicateId;
            }
        }
        return ids.toArray(new MailDocumentId[ids.size()]);
    }

    private MailDocumentId createMailDocumentId(MailDocument document, int duplicateId, String boxYear, String scid) {
        return new MailDocumentId(boxYear, document.getMetaData().getHashHex(), duplicateId, scid);
    }

    private void addJournalEntry(ArchivedMailDocument archivedMailDocument) {
        this.getJournal().addEntry(new SuccessfullyArchivedEntry(archivedMailDocument));
    }

    public void saveDocument(MailDocument document, MailDocumentId documentId) throws FailedArchivingException {
        try {
            if (this.readOnly) {
                throw new RuntimeArchiveException("Repositorydirectory \"" + this.getDirectory().getAbsolutePath() + "/" + documentId.getInternalBoxIndentifier() + "\" does not exist.");
            }
            try {
                this.createLocalMail(document, documentId);
            }
            catch (FailedArchivingException ex) {
                LOGGER.error("Failed to create tmp mail " + documentId.toString() + " for S3 upload. Stop uploading the mail.", (Throwable)ex);
                throw ex;
            }
            this.storage.ensureReadyFor(document, this.getIdentifier());
            OutputStream storageOutStream = this.storage.getOutStream(documentId, this.config.getCompression());
            this.startJournalThread(document);
            BoxEncryption encryption = this.config.getEncryption();
            storageOutStream = CompressionUtil.getOutStream(storageOutStream, this.config.getCompression());
            if (this.keyPair != null) {
                storageOutStream = CryptoUtils.encryptStream(storageOutStream, encryption.getEngine(), this.keyPair.getPublic());
            }
            document.saveBennoMail(storageOutStream);
        }
        catch (IOException ex) {
            this.getJournal().addEntry(new ArchivingFailedEntry(document, ex));
            LOGGER.fatal("Error writing mail to archive", (Throwable)ex);
            throw new FailedArchivingException(document, "Error writing mail to archive", ex);
        }
        catch (GeneralSecurityException e) {
            LOGGER.fatal("Error writing mail to archive", (Throwable)e);
            throw new FailedArchivingException(document, "Error writing mail to archive", e);
        }
        catch (ArchiveException e) {
            throw new RuntimeException(e);
        }
    }

    private void createLocalMail(MailDocument document, MailDocumentId documentId) throws ArchiveException, FailedArchivingException {
        if (this.config.getBoxStorageConfig().getDriver().equalsIgnoreCase("s3")) {
            FSMailFile localFile = new FSMailFile(documentId);
            localFile.createMailFile(document, this, this.readOnly);
        }
    }

    private void startJournalThread(MailDocument document) {
        if (this.config.getBoxStorageConfig().getDriver().equalsIgnoreCase("s3")) {
            ((IS3BennoStorage)this.storage).startJournalThread(this.journal, document);
        }
    }

    private MailDocument getDocumentFromStream(MailDocumentId id, boolean bennoParser) {
        try {
            InputStream storageInStream = this.getInputStream(id);
            if (bennoParser) {
                return new BennoMailfileParser().parseStream(storageInStream);
            }
            return new MailfileParser().parseStream(storageInStream);
        }
        catch (IOException ioex) {
            LOGGER.error("BAD", (Throwable)ioex);
            ioex.printStackTrace(System.out);
        }
        catch (Exception ex) {
            LOGGER.error("BAD", (Throwable)ex);
            ex.printStackTrace(System.out);
        }
        return null;
    }

    @Override
    public MailDocument getDocument(MailDocumentId id) {
        return this.getDocumentFromStream(id, true);
    }

    @Override
    public MailDocument getFullDocument(MailDocumentId id) {
        return this.getDocumentFromStream(id, false);
    }

    private InputStream getInputStream(MailDocumentId id) throws IOException, GeneralSecurityException {
        InputStream storageInStream = null;
        if (!id.getScid().equals("")) {
            File scidPath = this.getScidPath(id.getScid(), this.getIdentifier());
            IBennoStorage scaDirectory = this.createAndReturnBoxStorage(scidPath, this.getBoxConfig().getIdentifier());
            storageInStream = scaDirectory.getInStream(id, this.config.getCompression());
        } else {
            storageInStream = this.storage.getInStream(id, this.config.getCompression());
        }
        storageInStream = CompressionUtil.getInStream(storageInStream, this.config.getCompression());
        BoxEncryption encryption = this.config.getEncryption();
        if (encryption != null) {
            storageInStream = CryptoUtils.decryptStream(storageInStream, encryption.getEngine(), this.keyPair.getPrivate());
        }
        return storageInStream;
    }

    @Override
    public String closeBox() {
        return this.journal.closeJournal();
    }

    @Override
    public IJournal getJournal() {
        return this.journal;
    }

    @Override
    public boolean exists() {
        return this.storage.exists();
    }

    protected File getDirectory() {
        return this.directory;
    }
}

