/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.parser.ParserException;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.MimeUtility;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

@Root(name="header")
public class Header {
    @Attribute(name="name")
    private final String name;
    @Text(data=true)
    private final String body;

    public Header(byte[] inBytes) throws ParserException, UnsupportedEncodingException {
        this(MimeUtility.decodeText((String)new String(inBytes, "UTF-8")));
    }

    public Header(byte[] inBytes, String encodingname) throws ParserException, UnsupportedEncodingException {
        this(new String(inBytes, encodingname));
    }

    public Header(String name, String body) {
        this.name = name.replaceAll("\n", "").replaceAll("\r", "").trim();
        this.body = body.replaceAll("\n", "").replaceAll("\r", "").trim();
    }

    public Header(String headerline) throws ParserException {
        int splitPos = headerline.indexOf(":");
        if (splitPos < 0) {
            throw new ParserException("No \":\" in header \"" + headerline);
        }
        this.name = headerline.substring(0, splitPos).replaceAll("\n", "").replaceAll("\r", "").trim();
        this.body = headerline.substring(splitPos + 1).replaceAll("\n", "").replaceAll("\r", "").trim();
    }

    public String getHeaderline() {
        return this.name + ": " + this.body;
    }

    public String getName() {
        return this.name;
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        return this.getHeaderline();
    }

    public boolean equals(Object obj) {
        boolean equality = false;
        if (obj != null && obj instanceof Header) {
            equality = this.getName().equals(((Header)obj).getName()) && this.getBody().equals(((Header)obj).getBody());
        }
        return equality;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 17 * hash + (this.body != null ? this.body.hashCode() : 0);
        return hash;
    }
}

