/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailservice;

import com.google.common.eventbus.EventBus;
import de.lwsystems.mailarchive.config.IDirectoryWatchConfig;
import de.lwsystems.mailarchive.config.IFileParserConfig;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.maillistener.IMailListener;
import de.lwsystems.mailarchive.mailservice.BennoFileProcessor;
import de.lwsystems.mailarchive.mailservice.IMailService;
import de.lwsystems.mailarchive.parser.AbstractStreamFileParser;
import de.lwsystems.mailarchive.parser.BennoMailfileParser;
import de.lwsystems.mailarchive.parser.IFileParser;
import de.lwsystems.mailarchive.parser.MailfileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import de.lwsystems.mailarchive.remove.RemoveDocument;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class DirectoryWatchService
implements IMailService,
Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DirectoryWatchService.class);
    public static long WATCHINTERVALL = 5000L;
    private static final long MAXFILES = 500L;
    protected static final String ERRORSUFFIX = ".err";
    protected static final String PROCESSINGSUFFIX = ".prc";
    private final IFileParser fileParser;
    private final File directory;
    private final String pattern;
    private BennoFileProcessor fileProcessor;
    private Thread myThread;
    protected List<IMailListener> listeners = new ArrayList<IMailListener>();
    protected volatile boolean running = false;
    protected volatile boolean starting = false;
    private boolean destroyed = false;
    @Autowired
    private EventBus eventBus;

    private DirectoryWatchService(File directory, String pattern, IFileParser fileParser) {
        this.directory = directory;
        if (this.directory == null) {
            throw new IllegalArgumentException("Directory must not be empty");
        }
        if (!this.directory.exists()) {
            throw new IllegalArgumentException("\"" + directory.getAbsolutePath() + "\" does not exist");
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("\"" + directory.getAbsolutePath() + "\" is not a directory");
        }
        if (!this.directory.canRead()) {
            throw new IllegalArgumentException("Directory \"" + directory.getAbsolutePath() + "\" is not readable");
        }
        this.pattern = pattern == null || pattern.length() == 0 ? ".*" : pattern;
        if (fileParser == null) {
            throw new IllegalArgumentException("Fileparser must not be empty");
        }
        this.fileParser = fileParser;
    }

    public DirectoryWatchService(IDirectoryWatchConfig config) {
        this(new File(config.getDirectory()), config.getPattern(), DirectoryWatchService.createFileParser(config.getParser()));
    }

    @PostConstruct
    public void init() {
        this.fileProcessor = new BennoFileProcessor(this.directory, this.fileParser, this.listeners, this.eventBus);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public synchronized void destroy() {
        this.destroyed = true;
        this.fileProcessor.setDestroyed(true);
        this.stop();
        IMailListener[] listeners = new IMailListener[this.listeners.size()];
        for (IMailListener listener : listeners = this.listeners.toArray(listeners)) {
            this.removeMailListener(listener);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isStarting() {
        return this.starting;
    }

    @Override
    public void addMailListener(IMailListener listener) {
        if (!this.isDestroyed() && listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeMailListener(IMailListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
            listener.shutdown();
        }
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public synchronized void start() {
        if (!this.isDestroyed()) {
            if (!this.starting) {
                this.starting = true;
            }
            if (this.myThread == null || !this.myThread.isAlive()) {
                this.myThread = new Thread((Runnable)this, this.getIdentifier());
                this.myThread.setDaemon(false);
            }
            if (this.myThread != null && !this.myThread.isAlive()) {
                this.myThread.start();
            }
        }
    }

    public Thread getThread() {
        return this.myThread;
    }

    @Override
    public synchronized void stop() {
        if (this.starting) {
            this.starting = false;
        }
        this.doStop();
    }

    @Override
    public void run() {
        try {
            this.running = true;
            this.doRun();
        }
        catch (Exception ex) {
            this.starting = false;
            LOGGER.log(Level.ERROR, "Exception in Thread " + this.getIdentifier(), (Throwable)ex);
        }
        finally {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        DirectoryWatchService directoryWatchService = this;
        synchronized (directoryWatchService) {
            this.notify();
        }
        for (IMailListener l : this.listeners) {
            l.shutdown();
        }
    }

    @Override
    public String getState() {
        String state = this.starting ? (this.myThread != null && this.myThread.isAlive() ? "running" : "starting") : (this.myThread != null && this.myThread.isAlive() ? "stopping" : "stopped");
        return state;
    }

    private static IFileParser createFileParser(IFileParserConfig parser) {
        AbstractStreamFileParser fileParser = null;
        switch (parser.getType()) {
            case BENNO: {
                fileParser = new BennoMailfileParser(parser);
                break;
            }
            case MAILFILE: {
                fileParser = new MailfileParser(parser);
                break;
            }
            default: {
                throw new RuntimeException("bad configuration");
            }
        }
        return fileParser;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && obj instanceof DirectoryWatchService) {
            equal = this.directory.equals(((DirectoryWatchService)obj).directory) && this.pattern.equals(((DirectoryWatchService)obj).pattern);
        }
        return equal;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.directory != null ? this.directory.hashCode() : 0);
        hash = 97 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws Exception {
        while (this.starting) {
            long waitTime = System.currentTimeMillis() + WATCHINTERVALL;
            try {
                this.updateDirectory();
                this.removeDocument();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                LOGGER.error((Object)ex);
            }
            waitTime -= System.currentTimeMillis();
            DirectoryWatchService directoryWatchService = this;
            synchronized (directoryWatchService) {
                if (waitTime > 0L && waitTime < WATCHINTERVALL) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public String getIdentifier() {
        return "ImportPattern: " + this.directory.getAbsolutePath() + File.separator + this.pattern;
    }

    private void removeDocument() throws MessagingException, IOException, ParserException {
        List<RemoveDocument> activeInstances = RemoveDocument.getAllActiveInstances();
        for (RemoveDocument removeDocument : activeInstances) {
            if (removeDocument.isLogDelete()) {
                while (removeDocument.existsMailForRemove()) {
                    RemovedMailDocument removedDocument = removeDocument.getDocumentForRemove();
                    this.fileProcessor.addRemoveRepoJournalEntry(removedDocument);
                }
                continue;
            }
            while (removeDocument.existsMailForRemove()) {
                this.fileProcessor.removeDocument(removeDocument.getDocumentForRemove().getDocument());
            }
        }
    }

    private void updateDirectory() throws IOException {
        if (this.directory == null) {
            throw new IllegalArgumentException("Directory became null, stopping directorywatcher");
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                String name = entry.toString();
                return name.matches(DirectoryWatchService.this.pattern) && !name.endsWith(DirectoryWatchService.ERRORSUFFIX) && !name.endsWith(DirectoryWatchService.PROCESSINGSUFFIX) && Files.isRegularFile(entry, new LinkOption[0]);
            }
        };
        try (DirectoryStream<Path> files = Files.newDirectoryStream(Paths.get(this.directory.getAbsolutePath(), new String[0]), (DirectoryStream.Filter<? super Path>)filter);){
            for (Path file : files) {
                if (!this.starting) continue;
                this.fileProcessor.processFile(file);
            }
        }
    }
}

