/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.utils.FileNameSuffix;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Objects;

public class FileNameUtils {
    public static String changeMailSuffix(String incomingFileName, FileNameSuffix suffix) {
        Objects.requireNonNull(incomingFileName, "Incoming file name must not be null");
        Objects.requireNonNull(suffix, "Suffix must not be null");
        if (incomingFileName.length() < 4) {
            throw new IllegalArgumentException("Incoming file name is too short to have a suffix");
        }
        return incomingFileName.substring(0, incomingFileName.length() - 4) + suffix.getValue();
    }

    public static Path renameFile(Path filePath, FileNameSuffix suffix, File targetDirectory) throws IOException {
        Objects.requireNonNull(filePath, "File path must not be null");
        Objects.requireNonNull(suffix, "Suffix must not be null");
        Objects.requireNonNull(targetDirectory, "Target directory must not be null");
        String incomingFileName = filePath.getFileName().toString();
        String inprocessFilename = FileNameUtils.changeMailSuffix(incomingFileName, suffix);
        Path inprocessFilePath = targetDirectory.toPath().resolve(inprocessFilename);
        FileNameUtils.moveFile(filePath, inprocessFilePath);
        return inprocessFilePath;
    }

    private static void moveFile(Path source, Path target) throws IOException {
        Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
    }
}

