/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive;

import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.IArchiveGenerator;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentity;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentityService;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.config.ConfiguredArchiveGeneratorConfig;
import de.lwsystems.mailarchive.mailservice.IMailService;
import de.lwsystems.mailarchive.mailservice.IMailServiceHost;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.springframework.context.ApplicationContext;

public final class Benno {
    public static final String BENNNOVERSION = "2.10.5-SNAPSHOT";
    private static final Logger LOGGER = LogManager.getLogger(Benno.class);
    private static final int LOGCONFIGWATCHPERIOD = 60000;
    private final IMailServiceHost serviceHost;
    private final ApplicationContext context;
    private final IArchiveGenerator archiveGenerator;
    private BennoConfig config;

    public static void configureLogging() throws FactoryConfigurationError, URISyntaxException {
        Configurator.initialize((Configuration)new DefaultConfiguration());
        String logConfigName = null;
        if (System.getProperty("log4j.configurationFile") != null) {
            logConfigName = System.getProperty("log4j.configurationFile");
        } else if (System.getenv("LOG4J_CONFIG") != null) {
            logConfigName = System.getenv("LOG4J_CONFIG");
        } else if (new File("/etc/benno/bennocore-log4j.xml").exists()) {
            logConfigName = "/etc/benno/bennocore-log4j.xml";
        }
        if (logConfigName == null) {
            LOGGER.info("Using builtin log4j configuration");
            URL url = ClassLoader.getSystemResource("log4j.xml");
            Configurator.reconfigure((URI)url.toURI());
        } else {
            LOGGER.info("Using log4j configuration: " + logConfigName);
            Configurator.reconfigure((URI)new URI(logConfigName));
        }
    }

    public Benno(BennoConfig config, boolean readOnly, IMailServiceHost serviceHost, ApplicationContext context) throws Exception {
        this.serviceHost = serviceHost;
        this.context = context;
        this.config = config;
        if (config == null) {
            throw new Exception("no configuration");
        }
        this.archiveGenerator = this.createArchiveGenerator(config.getArchiveGenerator(), readOnly);
    }

    private IArchiveGenerator createArchiveGenerator(ConfiguredArchiveGeneratorConfig archiveGeneratorConfig, boolean readOnly) throws IOException {
        return new ConfiguredArchiveGenerator(this, archiveGeneratorConfig, readOnly);
    }

    public void configure(BennoConfig config) {
        LOGGER.info("Reloading configuration");
        this.config = config;
        this.archiveGenerator.configure(config.getArchiveGenerator());
    }

    public void listArchives(PrintWriter out) {
        for (IArchive archive : this.getArchives()) {
            out.print(archive.toString());
            out.print(": ");
            out.println(archive.getState());
        }
    }

    public Iterable<IArchive> getArchives() {
        return this.archiveGenerator.getArchives();
    }

    public Integer getNumberOfContainer() {
        int numberOfContainer = 0;
        for (IArchive archive : this.getArchives()) {
            for (IContainer archive2 : archive.getContainerGenerator().getContainers()) {
                ++numberOfContainer;
            }
        }
        return numberOfContainer;
    }

    public void optimizeIndex(String archivename, PrintWriter out) {
        try {
            IArchive archive = this.archiveGenerator.getArchive(archivename);
            if (archive != null) {
                if (archive.optimizeIndex()) {
                    out.println("Archive " + archivename + " index optimized");
                } else {
                    out.println("Archive " + archivename + " index not optimized");
                }
            }
        }
        catch (ArchiveNotFoundException ex) {
            out.println("Archive " + archivename + " not found");
        }
        catch (UnsupportedOperationException ex) {
            out.println("Archive " + archivename + " optimize repository not supported!");
        }
    }

    public IMailService registerService(IMailService service) {
        service = this.serviceHost != null ? this.serviceHost.registerService(service) : null;
        return service;
    }

    public String getIdentifier() {
        return this.archiveGenerator.getIdentifier();
    }

    public IBennoUserIdentity loadUser(IBennoUserIdentityService identityService, String username) {
        return this.archiveGenerator.loadUser(identityService, username);
    }

    public BennoConfig getConfig() {
        return this.config;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public IArchiveGenerator getArchiveGenerator() {
        return this.archiveGenerator;
    }
}

