/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.utils;

import de.lwsystems.mailarchive.archive.box.INameIteratorStrategy;
import de.lwsystems.mailarchive.archive.box.MultiNameIteratorStrategy;
import de.lwsystems.mailarchive.config.RotationInterval;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.joda.time.DurationFieldType;

public class NameIteratorUtil {
    public static INameIteratorStrategy createNameIteratorStrategy(RotationInterval type) {
        return switch (type) {
            case RotationInterval.MINUTELY -> new MultiNameIteratorStrategy("yyyyMMddHHmm", DurationFieldType.minutes(), 1);
            case RotationInterval.MONTHLY -> new MultiNameIteratorStrategy("yyyyMM", DurationFieldType.months(), 1);
            case RotationInterval.QUARTERLY -> new MultiNameIteratorStrategy("yyyy", DurationFieldType.months(), 1){

                @Override
                public String getBoxNameForDate(Date date) {
                    String dateFormatted = super.getBoxNameForDate(date);
                    Calendar calendar = Clock.getProvider().getCalendarInstance(Locale.ROOT);
                    calendar.setTime(date);
                    return DateUtil.getQuartalString(dateFormatted, calendar);
                }
            };
            case RotationInterval.SINGLE -> new INameIteratorStrategy(){

                @Override
                public String getBoxNameForDate(Date date) {
                    return null;
                }

                @Override
                public Iterator<String> getIterator() {
                    return new Iterator<String>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public String next() {
                            return null;
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
            };
            case RotationInterval.DAILY -> new MultiNameIteratorStrategy("yyyyMMdd", DurationFieldType.days(), 1);
            case RotationInterval.WEEKLY -> new MultiNameIteratorStrategy("yyyy'w'ww", DurationFieldType.weeks(), 1);
            case RotationInterval.YEARLY -> new MultiNameIteratorStrategy("yyyy", DurationFieldType.months(), 1);
            default -> throw new RuntimeException("bad config");
        };
    }
}

