/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.backup;

import de.lwsystems.mailarchive.journal.ChecksumEntry;
import de.lwsystems.mailarchive.journal.ChecksumValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChecksumListIterator
implements Iterator<ChecksumEntry>,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(ChecksumListIterator.class);
    private final BufferedReader reader;
    private ChecksumEntry nextEntry;
    private boolean finished;
    private long totalLines;
    private long validLines;
    private long invalidLines;
    private long commentLines;
    private long emptyLines;

    public ChecksumListIterator(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        this.finished = false;
        this.totalLines = 0L;
        this.validLines = 0L;
        this.invalidLines = 0L;
        this.commentLines = 0L;
        this.emptyLines = 0L;
        this.advanceToNextValidEntry();
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public ChecksumEntry next() {
        if (this.nextEntry == null) {
            throw new NoSuchElementException("No more checksums available");
        }
        ChecksumEntry result = this.nextEntry;
        this.advanceToNextValidEntry();
        return result;
    }

    private void advanceToNextValidEntry() {
        this.nextEntry = null;
        if (this.finished) {
            return;
        }
        while (this.nextEntry == null && !this.finished) {
            try {
                String line = this.reader.readLine();
                ++this.totalLines;
                if (line == null) {
                    this.finished = true;
                    return;
                }
                if ((line = line.trim()).isEmpty()) {
                    ++this.emptyLines;
                    continue;
                }
                if (line.startsWith("#")) {
                    ++this.commentLines;
                    continue;
                }
                ChecksumEntry entry = this.parseLine(line);
                if (entry != null) {
                    this.nextEntry = entry;
                    ++this.validLines;
                    continue;
                }
                ++this.invalidLines;
            }
            catch (IOException e) {
                LOGGER.error("Error reading checksum list: {}", (Object)e.getMessage());
                this.finished = true;
                return;
            }
        }
    }

    private ChecksumEntry parseLine(String line) {
        String normalized = ChecksumValidator.normalizeYearBoxAndChecksum(line);
        if (normalized == null) {
            LOGGER.debug("Invalid checksum entry format: {}", (Object)line);
            return null;
        }
        int colonIndex = normalized.indexOf(58);
        String yearBox = normalized.substring(0, colonIndex);
        String checksum = normalized.substring(colonIndex + 1);
        return new ChecksumEntry(normalized, checksum, yearBox);
    }

    private boolean isValidYearBox(String yearBox) {
        return ChecksumValidator.isValidYearBoxFormat(yearBox);
    }

    private boolean isValidChecksum(String checksum) {
        return ChecksumValidator.isValid66Checksum(checksum);
    }

    public long getTotalLines() {
        return this.totalLines;
    }

    public long getValidLines() {
        return this.validLines;
    }

    public long getInvalidLines() {
        return this.invalidLines;
    }

    public long getCommentLines() {
        return this.commentLines;
    }

    public long getEmptyLines() {
        return this.emptyLines;
    }

    public String getStatisticsSummary() {
        return String.format("Total lines: %d, Valid: %d, Invalid: %d, Comments: %d, Empty: %d", this.totalLines, this.validLines, this.invalidLines, this.commentLines, this.emptyLines);
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error closing checksum list reader: {}", (Object)e.getMessage());
        }
    }
}

