/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.backup.mailcontentwriter;

import de.lwsystems.mailarchive.backup.mailcontentwriter.MailContentWriter;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BennoHeaderMailContentWriter
implements MailContentWriter {
    private static final Logger LOGGER = LogManager.getLogger(BennoHeaderMailContentWriter.class);

    @Override
    public void write(MailDocument doc, OutputStream out) throws IOException {
        try {
            byte[] data = doc.getMailData();
            int pos = 0;
            int len = data.length;
            while (pos < len) {
                int lineEnd = BennoHeaderMailContentWriter.indexOf(data, pos, len, (byte)10);
                if (lineEnd == -1) {
                    lineEnd = len;
                }
                int lineContentEnd = lineEnd > pos && data[lineEnd - 1] == 13 ? lineEnd - 1 : lineEnd;
                String line = new String(data, pos, lineContentEnd - pos, StandardCharsets.US_ASCII);
                int nextLine = Math.min(lineEnd + 1, len);
                if (line.contains("===== Hash")) {
                    pos = nextLine;
                    break;
                }
                if (line.contains("Sender:")) {
                    BennoHeaderMailContentWriter.writeLine(out, line.replace("Sender:", "X-REAL-MAILFROM:"));
                } else if (line.contains("Recipient:")) {
                    BennoHeaderMailContentWriter.writeLine(out, line.replace("Recipient:", "X-REAL-RCPTTO:"));
                } else if (line.contains("X-BENNO-GW")) {
                    BennoHeaderMailContentWriter.writeLine(out, line);
                }
                pos = nextLine;
            }
            if (pos < len) {
                out.write(data, pos, len - pos);
            }
            out.flush();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                IOException io = (IOException)e;
                throw io;
            }
            LOGGER.debug("Header write error: {}", (Object)e.getMessage());
            throw new IOException("Error while writing mail with Benno header: " + e.getMessage(), e);
        }
    }

    private static void writeLine(OutputStream out, String line) throws IOException {
        out.write(line.getBytes(StandardCharsets.US_ASCII));
        out.write(13);
        out.write(10);
    }

    private static int indexOf(byte[] data, int from, int to, byte value) {
        for (int i = from; i < to; ++i) {
            if (data[i] != value) continue;
            return i;
        }
        return -1;
    }
}

