/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.backup.service;

import de.lwsystems.mailarchive.backup.service.BackupArchiveStreamWriter;
import de.lwsystems.mailarchive.backup.service.TarArchiveStreamWriter;
import de.lwsystems.mailarchive.backup.service.ZipArchiveStreamWriter;
import java.io.OutputStream;
import java.util.Locale;

public enum ArchiveFormat {
    TAR,
    ZIP;


    public String fileExtension() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TAR -> ".tar";
            case ZIP -> ".zip";
        };
    }

    public String contentType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TAR -> "application/x-tar";
            case ZIP -> "application/zip";
        };
    }

    public BackupArchiveStreamWriter createWriter(OutputStream out) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TAR -> new TarArchiveStreamWriter(out);
            case ZIP -> new ZipArchiveStreamWriter(out);
        };
    }

    public static ArchiveFormat fromParam(String param) {
        if (param == null || param.isBlank()) {
            return TAR;
        }
        return switch (param.toLowerCase(Locale.ROOT)) {
            case "tar" -> TAR;
            case "zip", "zip64" -> ZIP;
            default -> throw new IllegalArgumentException("Invalid archiveFormat: '" + param + "'. Supported values: tar, zip");
        };
    }
}

