/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.backup.service;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.backup.mailcontentwriter.BennoHeaderMailContentWriter;
import de.lwsystems.mailarchive.backup.mailcontentwriter.MailContentWriter;
import de.lwsystems.mailarchive.backup.mailcontentwriter.RawMailContentWriter;
import de.lwsystems.mailarchive.backup.service.BackupArchiveStreamWriter;
import de.lwsystems.mailarchive.backup.service.BackupFormat;
import de.lwsystems.mailarchive.journal.ChecksumEntry;
import de.lwsystems.mailarchive.journal.ChecksumValidator;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupArchiveService {
    private static final Logger LOGGER = LogManager.getLogger(BackupArchiveService.class);
    public static final long NO_SIZE_LIMIT = -1L;
    private final MailContentWriter rawWriter;
    private final MailContentWriter headerWriter;
    private IBox actualContainerBox;

    public BackupArchiveService() {
        this(new RawMailContentWriter(), new BennoHeaderMailContentWriter());
    }

    public BackupArchiveService(MailContentWriter rawWriter, MailContentWriter headerWriter) {
        this.rawWriter = rawWriter;
        this.headerWriter = headerWriter;
    }

    public void loadBox(IContainer container, String yearBox) throws ArchiveException {
        if (this.actualContainerBox == null || !this.actualContainerBox.getIdentifier().equalsIgnoreCase(yearBox)) {
            this.actualContainerBox = container.getBox(yearBox);
        }
    }

    public int streamEntries(IContainer container, Iterator<ChecksumEntry> entries, boolean includeBennoHeader, BackupArchiveStreamWriter writer, BackupFormat format) throws IOException {
        return this.streamEntries(container, entries, includeBennoHeader, writer, -1L, format).successCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamingResult streamEntries(IContainer container, Iterator<ChecksumEntry> entries, boolean includeBennoHeader, BackupArchiveStreamWriter writer, long maxSizeBytes, BackupFormat format) throws IOException {
        long effectiveMaxSize;
        int successCount = 0;
        String lastChecksum = null;
        long currentSize = 0L;
        boolean truncated = false;
        long footerSize = writer.estimateFooterSize();
        long l = effectiveMaxSize = maxSizeBytes > 0L ? maxSizeBytes - footerSize : Long.MAX_VALUE;
        while (entries.hasNext()) {
            ChecksumEntry entry = entries.next();
            String yearBox = entry.yearBox();
            String checksumWithSuffix = entry.checksum();
            if (yearBox == null || yearBox.trim().isEmpty()) {
                LOGGER.debug("Skip checksum {} due to unknown year box", (Object)checksumWithSuffix);
                continue;
            }
            if (this.validChecksumCheck(checksumWithSuffix)) continue;
            String checksum = checksumWithSuffix.substring(0, 64);
            String duplicateHex = checksumWithSuffix.substring(64, 66);
            try {
                this.loadBox(container, yearBox);
                MailDocument doc = this.loadMailDocument(includeBennoHeader, yearBox, checksum, duplicateHex);
                if (doc == null) {
                    LOGGER.debug("Document not found for id {}:{}, skipping", (Object)yearBox, (Object)checksumWithSuffix);
                    continue;
                }
                Path tempFile = Files.createTempFile("benno-backup-", format.tempFileSuffix(), new FileAttribute[0]);
                try {
                    this.writeTempFile(includeBennoHeader, tempFile, doc, format);
                    long fileSize = Files.size(tempFile);
                    String entryPath = yearBox + ":" + checksumWithSuffix + format.fileExtension();
                    int pathBytes = entryPath.getBytes(StandardCharsets.UTF_8).length;
                    long entrySize = writer.estimateEntryOverhead(fileSize, pathBytes);
                    if (maxSizeBytes > 0L && currentSize + entrySize > effectiveMaxSize) {
                        LOGGER.info("Size limit reached. Current size: {} bytes, entry would add: {} bytes, limit: {} bytes", (Object)currentSize, (Object)entrySize, (Object)maxSizeBytes);
                        truncated = true;
                        break;
                    }
                    writer.writeEntry(entryPath, tempFile, fileSize);
                    currentSize += entrySize;
                    lastChecksum = entry.fullChecksum();
                    ++successCount;
                }
                finally {
                    try {
                        Files.deleteIfExists(tempFile);
                    }
                    catch (IOException ignore) {
                        LOGGER.warn("Could not delete temp file {}", (Object)tempFile);
                    }
                }
            }
            catch (IOException io) {
                LOGGER.warn("I/O during streaming {}:{}, stopping: {}", (Object)entry.yearBox(), (Object)entry.checksum(), (Object)io.getMessage());
                if (successCount != 0) break;
                throw io;
            }
            catch (Exception ex) {
                LOGGER.warn("Error adding {}:{} to backup: {}", (Object)entry.yearBox(), (Object)entry.checksum(), (Object)ex.toString());
            }
        }
        long totalSize = successCount > 0 ? currentSize + footerSize : 0L;
        return new StreamingResult(successCount, lastChecksum, totalSize, truncated);
    }

    private boolean validChecksumCheck(String checksumWithSuffix) {
        if (!ChecksumValidator.isValid66Checksum(checksumWithSuffix)) {
            LOGGER.debug("Skip checksum {} - invalid format (expected 66 hex chars, got length {})", (Object)checksumWithSuffix, (Object)(checksumWithSuffix != null ? checksumWithSuffix.length() : 0));
            return true;
        }
        return false;
    }

    private void writeTempFile(boolean includeBennoHeader, Path tempFile, MailDocument doc, BackupFormat format) throws IOException {
        block17: {
            MailContentWriter contentWriter = includeBennoHeader ? this.headerWriter : this.rawWriter;
            try (OutputStream fos = Files.newOutputStream(tempFile, StandardOpenOption.TRUNCATE_EXISTING);
                 BufferedOutputStream bos = new BufferedOutputStream(fos);){
                if (format == BackupFormat.GZIP) {
                    try (GZIPOutputStream gzip = new GZIPOutputStream(bos);){
                        contentWriter.write(doc, gzip);
                        break block17;
                    }
                }
                contentWriter.write(doc, bos);
                bos.flush();
            }
        }
    }

    private MailDocument loadMailDocument(boolean includeBennoHeader, String yearBox, String checksum, String duplicateHex) {
        MailDocumentId docId = new MailDocumentId(yearBox + ":" + checksum + duplicateHex, "");
        return includeBennoHeader ? this.actualContainerBox.getFullDocument(docId) : this.actualContainerBox.getDocument(docId);
    }

    public record StreamingResult(int successCount, String lastChecksum, long totalSize, boolean truncated) {
    }
}

