/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.backup.service;

import de.lwsystems.mailarchive.backup.service.BackupArchiveStreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarArchiveStreamWriter
implements BackupArchiveStreamWriter {
    private static final int TAR_HEADER_SIZE = 512;
    private static final int TAR_BLOCK_SIZE = 512;
    private static final int TAR_FOOTER_SIZE = 1024;
    private static final int BUFFER_SIZE = 65536;
    private final TarArchiveOutputStream tarOut;

    public TarArchiveStreamWriter(OutputStream out) {
        this.tarOut = new TarArchiveOutputStream(out);
        this.tarOut.setLongFileMode(2);
    }

    @Override
    public void writeEntry(String entryPath, Path contentFile, long contentSize) throws IOException {
        TarArchiveEntry tarEntry = new TarArchiveEntry(entryPath);
        tarEntry.setSize(contentSize);
        this.tarOut.putArchiveEntry((ArchiveEntry)tarEntry);
        try (InputStream in = Files.newInputStream(contentFile, new OpenOption[0]);){
            int read;
            byte[] buf = new byte[65536];
            while ((read = in.read(buf)) != -1) {
                this.tarOut.write(buf, 0, read);
            }
        }
        this.tarOut.closeArchiveEntry();
    }

    @Override
    public void finish() throws IOException {
        this.tarOut.finish();
    }

    @Override
    public long estimateEntryOverhead(long contentSize, int pathLength) {
        long paddedDataSize = (contentSize + 512L - 1L) / 512L * 512L;
        return 512L + paddedDataSize;
    }

    @Override
    public long estimateFooterSize() {
        return 1024L;
    }

    @Override
    public String archiveExtension() {
        return ".tar";
    }

    @Override
    public void close() throws IOException {
        this.tarOut.close();
    }
}

