/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.journal.FSJournalReader;
import de.lwsystems.mailarchive.journal.ChecksumBoundary;
import de.lwsystems.mailarchive.journal.ChecksumEntry;
import de.lwsystems.mailarchive.journal.JournalEntry;
import de.lwsystems.mailarchive.journal.JournalFileLocator;
import de.lwsystems.mailarchive.journal.JournalOperation;
import de.lwsystems.mailarchive.journal.JournalParser;
import de.lwsystems.mailarchive.journal.ProcessingError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChecksumStreamingIterator
implements Iterator<ChecksumEntry>,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(ChecksumStreamingIterator.class);
    private final List<Path> journalFiles;
    private final JournalParser parser;
    private final ChecksumBoundary startBoundary;
    private final ChecksumBoundary endBoundary;
    private final boolean bounded;
    private final List<ProcessingError> errors;
    private int currentFileIndex;
    private Iterator<JournalEntry> currentEntryIterator;
    private ChecksumEntry nextEntry;
    private boolean selectionActive;
    private boolean finished;
    private long totalProcessed;

    public ChecksumStreamingIterator(IContainer container, JournalFileLocator fileLocator, JournalParser parser, ChecksumBoundary startBoundary, ChecksumBoundary endBoundary) throws IOException {
        this.parser = parser;
        this.startBoundary = startBoundary;
        this.endBoundary = endBoundary;
        this.bounded = startBoundary != null && startBoundary.isPresent() || endBoundary != null && endBoundary.isPresent();
        this.errors = new ArrayList<ProcessingError>();
        this.currentFileIndex = 0;
        this.totalProcessed = 0L;
        this.finished = false;
        String startChecksumForFileLocator = startBoundary != null ? startBoundary.checksum() : null;
        this.journalFiles = fileLocator.findJournalFiles(container, startChecksumForFileLocator).collect(Collectors.toList());
        Collections.reverse(this.journalFiles);
        if (this.bounded) {
            boolean hasStart;
            boolean bl = hasStart = startBoundary != null && startBoundary.isPresent();
            this.selectionActive = !hasStart;
        } else {
            this.selectionActive = true;
        }
        this.advanceToNextValidEntry();
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public ChecksumEntry next() {
        if (this.nextEntry == null) {
            throw new NoSuchElementException("No more checksums available");
        }
        ChecksumEntry result = this.nextEntry;
        this.advanceToNextValidEntry();
        return result;
    }

    private void advanceToNextValidEntry() {
        this.nextEntry = null;
        if (this.finished) {
            return;
        }
        block0: while (this.nextEntry == null && !this.finished) {
            if (!(this.currentEntryIterator != null && this.currentEntryIterator.hasNext() || this.loadNextFile())) {
                this.finished = true;
                return;
            }
            while (this.currentEntryIterator.hasNext() && this.nextEntry == null) {
                JournalEntry entry = this.currentEntryIterator.next();
                ++this.totalProcessed;
                if (!entry.success()) continue;
                String checksum = entry.checksumEntry().checksum();
                JournalOperation op = entry.operation();
                if (op == JournalOperation.REPO_DELETE) continue;
                if (this.bounded) {
                    if (!this.handleBoundedQuery(entry, checksum, op)) {
                        if (!this.finished) continue;
                        continue block0;
                    }
                } else if (op != JournalOperation.ARCHIVED) continue;
                if (op != JournalOperation.ARCHIVED) continue;
                this.nextEntry = entry.checksumEntry();
            }
        }
    }

    private boolean handleBoundedQuery(JournalEntry entry, String checksum, JournalOperation op) {
        boolean hasStart = this.startBoundary != null && this.startBoundary.isPresent();
        boolean hasEnd = this.endBoundary != null && this.endBoundary.isPresent();
        String fullChecksum = entry.checksumEntry().fullChecksum();
        if (hasStart && fullChecksum.equals(this.startBoundary.checksum())) {
            if (hasEnd && this.startBoundary.checksum().equals(this.endBoundary.checksum())) {
                boolean includeStart = this.startBoundary.inclusive();
                boolean includeEnd = this.endBoundary.inclusive();
                if (includeStart && includeEnd && op == JournalOperation.ARCHIVED) {
                    this.finished = true;
                    return true;
                }
                this.finished = true;
                return false;
            }
            if (!this.selectionActive) {
                this.selectionActive = true;
                if (this.startBoundary.inclusive()) {
                    return op == JournalOperation.ARCHIVED;
                }
                return false;
            }
        }
        if (hasEnd && fullChecksum.equals(this.endBoundary.checksum()) && this.selectionActive) {
            if (this.endBoundary.inclusive()) {
                if (op == JournalOperation.ARCHIVED) {
                    this.finished = true;
                    return true;
                }
                this.finished = true;
                return false;
            }
            this.finished = true;
            return false;
        }
        return this.selectionActive;
    }

    private boolean loadNextFile() {
        if (this.currentFileIndex >= this.journalFiles.size()) {
            return false;
        }
        Path file = this.journalFiles.get(this.currentFileIndex++);
        try {
            FSJournalReader reader = new FSJournalReader();
            this.currentEntryIterator = this.parser.parseFile(file, reader, true);
            return true;
        }
        catch (Exception e) {
            String error = String.format("Failed to process file: %s", e.getMessage());
            LOGGER.warn("Error processing journal file {}: {}", (Object)file, (Object)error);
            this.errors.add(new ProcessingError(file.toString(), error));
            return this.loadNextFile();
        }
    }

    public long getTotalProcessed() {
        return this.totalProcessed;
    }

    public List<ProcessingError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public void close() {
        this.currentEntryIterator = null;
        this.nextEntry = null;
    }
}

