/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.journal.ChecksumBoundary;
import de.lwsystems.mailarchive.journal.ChecksumEntry;
import de.lwsystems.mailarchive.journal.ChecksumStreamingIterator;
import de.lwsystems.mailarchive.journal.DefaultJournalFileLocator;
import de.lwsystems.mailarchive.journal.DefaultJournalParser;
import de.lwsystems.mailarchive.journal.JournalChecksumResult;
import de.lwsystems.mailarchive.journal.JournalFileLocator;
import de.lwsystems.mailarchive.journal.JournalParser;
import de.lwsystems.mailarchive.journal.JournalProcessingException;
import de.lwsystems.mailarchive.journal.JournalServiceConfig;
import de.lwsystems.mailarchive.journal.ProcessingError;
import de.lwsystems.mailarchive.journal.ResponseTooLargeException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JournalChecksumService {
    private static final Logger LOGGER = LogManager.getLogger(JournalChecksumService.class);
    private final JournalServiceConfig config;
    private final JournalFileLocator fileLocator;
    private final JournalParser parser;

    public JournalChecksumService() {
        this(JournalServiceConfig.builder().build());
    }

    public JournalChecksumService(JournalServiceConfig config) {
        this(config, new DefaultJournalFileLocator(), new DefaultJournalParser());
    }

    public JournalChecksumService(JournalServiceConfig config, JournalFileLocator fileLocator, JournalParser parser) {
        this.config = Objects.requireNonNull(config, "Config cannot be null");
        this.fileLocator = Objects.requireNonNull(fileLocator, "File locator cannot be null");
        this.parser = Objects.requireNonNull(parser, "Parser cannot be null");
        LOGGER.debug("JournalChecksumService initialized with config: maxResponseSize={}, timeout={}s, threadPoolSize={}", (Object)config.getMaxResponseSize(), (Object)config.getTimeout().getSeconds(), (Object)config.getThreadPoolSize());
    }

    public ChecksumStreamingIterator streamChecksumsFromContainer(IContainer container, ChecksumBoundary startBoundary, ChecksumBoundary endBoundary) throws IOException, JournalProcessingException {
        this.validateContainer(container);
        try {
            return new ChecksumStreamingIterator(container, this.fileLocator, this.parser, startBoundary, endBoundary);
        }
        catch (Exception e) {
            LOGGER.error("Error creating checksum stream for container {}: {}", (Object)container.getIdentifier(), (Object)e.getMessage(), (Object)e);
            throw new JournalProcessingException("Failed to create checksum stream", e);
        }
    }

    public JournalChecksumResult getChecksumsFromContainer(IContainer container, String startChecksum, String endChecksum) throws IOException, JournalProcessingException {
        return this.processContainer(container, startChecksum, endChecksum, 0, this.config.getMaxResponseSize());
    }

    public JournalChecksumResult getChecksumsFromContainer(IContainer container, String startChecksum, String endChecksum, int offset, int limit) throws IOException, JournalProcessingException {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be >= 0");
        }
        if (limit <= 0 || limit > this.config.getMaxPageSize()) {
            throw new IllegalArgumentException(String.format("Limit must be between 1 and %d", this.config.getMaxPageSize()));
        }
        return this.processContainer(container, startChecksum, endChecksum, offset, limit);
    }

    private JournalChecksumResult processContainer(IContainer container, String startChecksum, String endChecksum, int offset, int limit) throws IOException, JournalProcessingException {
        this.validateContainer(container);
        ChecksumBoundary startBoundary = startChecksum != null && !startChecksum.isBlank() ? ChecksumBoundary.at(startChecksum) : null;
        ChecksumBoundary endBoundary = endChecksum != null && !endChecksum.isBlank() ? ChecksumBoundary.at(endChecksum) : null;
        long startTime = System.currentTimeMillis();
        ArrayList<ChecksumEntry> selectedEntries = new ArrayList<ChecksumEntry>();
        ChecksumStreamingIterator iterator = new ChecksumStreamingIterator(container, this.fileLocator, this.parser, startBoundary, endBoundary);
        try {
            int currentIndex = 0;
            int collected = 0;
            int totalValidCount = 0;
            while (iterator.hasNext()) {
                ChecksumEntry entry = iterator.next();
                ++totalValidCount;
                if (currentIndex < offset) {
                    ++currentIndex;
                    continue;
                }
                if (collected < limit) {
                    selectedEntries.add(entry);
                    ++collected;
                }
                ++currentIndex;
            }
            List<ProcessingError> errors = iterator.getErrors();
            if (selectedEntries.size() > this.config.getMaxResponseSize()) {
                throw new ResponseTooLargeException(selectedEntries.size(), this.config.getMaxResponseSize());
            }
            long processingTime = System.currentTimeMillis() - startTime;
            JournalChecksumResult journalChecksumResult = JournalChecksumResult.builder().checksums(selectedEntries).totalCount(totalValidCount).truncated(selectedEntries.size() >= limit && totalValidCount > offset + limit).message(this.generateMessage(selectedEntries.size(), totalValidCount, offset, limit)).processingTimeMillis(processingTime).errors(errors).build();
            iterator.close();
            return journalChecksumResult;
        }
        catch (Throwable throwable) {
            try {
                try {
                    iterator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Error processing container {}: {}", (Object)container.getIdentifier(), (Object)e.getMessage(), (Object)e);
                if (e instanceof JournalProcessingException) {
                    throw (JournalProcessingException)e;
                }
                throw new JournalProcessingException("Failed to process container", e);
            }
        }
    }

    private void validateContainer(IContainer container) throws IOException, SecurityException {
        if (container == null) {
            throw new IllegalArgumentException("Container cannot be null");
        }
        IBoxGenerator boxGenerator = container.getBoxGenerator();
        if (boxGenerator == null) {
            throw new IOException("No box generator found for container: " + container.getIdentifier());
        }
        String baseDirectory = boxGenerator.getBoxGeneratorConfig().getDirectory();
        if (baseDirectory == null || baseDirectory.isEmpty()) {
            throw new IOException("No base directory configured for container: " + container.getIdentifier());
        }
        Path containerPath = Paths.get(baseDirectory, new String[0]).normalize().toAbsolutePath();
        if (!Files.exists(containerPath, new LinkOption[0]) || !Files.isDirectory(containerPath, new LinkOption[0])) {
            throw new IOException("Container directory does not exist or is not a directory: " + String.valueOf(containerPath));
        }
    }

    private String generateMessage(int returnedCount, int totalProcessed, int offset, int limit) {
        if (offset > 0 || returnedCount < limit) {
            return String.format("Showing results %d-%d of %d total processed", offset + 1, offset + returnedCount, totalProcessed);
        }
        return null;
    }

    public void shutdown() {
        LOGGER.debug("JournalChecksumService shutdown complete");
    }
}

