/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReverseLineReader
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(ReverseLineReader.class);
    private final boolean isCompressed;
    private final List<String> lines;
    private int currentLineIndex;
    private boolean finished;

    public ReverseLineReader(Path filePath) throws IOException {
        this.isCompressed = filePath.toString().endsWith(".gz");
        this.finished = false;
        if (this.isCompressed) {
            LOGGER.debug("Reading compressed file {} into memory for reverse iteration", (Object)filePath);
            this.lines = this.readCompressedFile(filePath);
        } else {
            LOGGER.debug("Reading uncompressed file {} into memory for reverse iteration", (Object)filePath);
            this.lines = this.readUncompressedFile(filePath);
        }
        this.currentLineIndex = this.lines.size() - 1;
        LOGGER.debug("Loaded {} lines from {}", (Object)this.lines.size(), (Object)filePath);
    }

    public String readLine() throws IOException {
        if (this.finished || this.currentLineIndex < 0) {
            this.finished = true;
            return null;
        }
        String line = this.lines.get(this.currentLineIndex);
        --this.currentLineIndex;
        return line;
    }

    private List<String> readUncompressedFile(Path path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream fileIn = Files.newInputStream(path, new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(fileIn, StandardCharsets.UTF_8);
             BufferedReader buffered = new BufferedReader(reader);){
            String line;
            while ((line = buffered.readLine()) != null) {
                result.add(line);
            }
        }
        return result;
    }

    private List<String> readCompressedFile(Path path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream fileIn = Files.newInputStream(path, new OpenOption[0]);
             GZIPInputStream gzipIn = new GZIPInputStream(fileIn);
             InputStreamReader reader = new InputStreamReader((InputStream)gzipIn, StandardCharsets.UTF_8);
             BufferedReader buffered = new BufferedReader(reader);){
            String line;
            while ((line = buffered.readLine()) != null) {
                result.add(line);
            }
        }
        return result;
    }

    public int getTotalLines() {
        return this.lines != null ? this.lines.size() : 0;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public void close() throws IOException {
        if (this.lines != null) {
            this.lines.clear();
        }
        this.finished = true;
    }
}

