/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;

public class UniversalAttachmentExtractor {
    private static final Pattern FILENAME_PATTERN = Pattern.compile("(filename|name)\\*?\\s*=\\s*(.*)", 2);
    private static final Pattern CONTENT_ID_PATTERN = Pattern.compile("<(.+)>");
    private static final MimeTypes MIME_TYPES = MimeTypes.getDefaultMimeTypes();

    public static String extractFilename(BodyPart bp) throws MessagingException, IOException {
        String[] contentIdHeader;
        if ((bp.isMimeType("text/html") || bp.isMimeType("text/plain")) && (bp.getDisposition() == null || bp.getDisposition().equalsIgnoreCase("inline"))) {
            return "";
        }
        String fileName = UniversalAttachmentExtractor.extractFileNameFromContentDisposition(bp);
        String[] contentTypeHeader = bp.getHeader("Content-Type");
        if (contentTypeHeader != null && contentTypeHeader.length > 0) {
            String contentType = contentTypeHeader[0];
            if (fileName == null) {
                fileName = UniversalAttachmentExtractor.extractFileNameFromContentType(contentType);
            }
        }
        if ((contentIdHeader = bp.getHeader("Content-Id")) != null && contentIdHeader.length > 0) {
            String contentId = contentIdHeader[0];
            if (fileName == null) {
                fileName = UniversalAttachmentExtractor.extractFileNameFromContentId(contentId);
            }
        }
        if (fileName == null) {
            fileName = bp.getFileName();
        }
        if (fileName != null) {
            fileName = MimeUtility.decodeText((String)fileName);
            fileName = UniversalAttachmentExtractor.ensureFileExtension(fileName, bp);
        }
        return fileName != null && !fileName.isEmpty() ? fileName : UniversalAttachmentExtractor.generateDefaultFilename(bp);
    }

    private static String extractFileNameFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        try {
            return new ContentType(contentType).getParameter("name");
        }
        catch (ParseException e) {
            Matcher matcher = FILENAME_PATTERN.matcher(contentType);
            return matcher.find() ? matcher.group(2).replaceAll("^\"|\"$", "").trim() : null;
        }
    }

    private static String extractFileNameFromContentId(String contentId) {
        if (contentId == null) {
            return null;
        }
        Matcher cidMatcher = CONTENT_ID_PATTERN.matcher(contentId);
        if (cidMatcher.find()) {
            return cidMatcher.group(1).replaceAll("[^\\w.-]", "_");
        }
        return contentId.replaceAll("[<>]", "").replaceAll("[^\\w.-]", "_");
    }

    private static String extractFileNameFromContentDisposition(BodyPart bp) throws MessagingException, UnsupportedEncodingException {
        String[] contentDisp = bp.getHeader("Content-Disposition");
        if (contentDisp == null || contentDisp.length == 0) {
            return null;
        }
        try {
            ParameterList params = new ParameterList(contentDisp[0]);
            return UniversalAttachmentExtractor.getFilenameFromContentDisposition(params);
        }
        catch (ParseException e) {
            Matcher matcher = FILENAME_PATTERN.matcher(contentDisp[0]);
            return UniversalAttachmentExtractor.decodeUTF8Text(matcher.find() ? matcher.group(2).replaceAll("\"", "") : null);
        }
    }

    private static String getFilenameFromContentDisposition(ParameterList params) throws UnsupportedEncodingException {
        if (params.get("filename") != null && !params.get("filename").isEmpty()) {
            return UniversalAttachmentExtractor.decodeUTF8Text(params.get("filename"));
        }
        if (params.get("name") != null && !params.get("name").isEmpty()) {
            return UniversalAttachmentExtractor.decodeUTF8Text(params.get("name"));
        }
        return null;
    }

    private static String decodeUTF8Text(String fileName) throws UnsupportedEncodingException {
        if (fileName != null && fileName.startsWith("UTF-8''")) {
            fileName = MimeUtility.decodeText((String)fileName.substring(7));
        }
        return fileName;
    }

    private static String ensureFileExtension(String fileName, BodyPart bp) throws MessagingException {
        if (fileName == null) {
            return null;
        }
        String mimeTypeExtension = UniversalAttachmentExtractor.getFileExtension(bp);
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return fileName + mimeTypeExtension;
        }
        String currentExtension = fileName.substring(lastDotIndex);
        if (!currentExtension.equalsIgnoreCase(mimeTypeExtension)) {
            return fileName + mimeTypeExtension;
        }
        return fileName;
    }

    private static String generateDefaultFilename(BodyPart bp) throws MessagingException {
        try {
            String contentDisposition = bp.getDisposition();
            if (contentDisposition != null && !contentDisposition.isEmpty()) {
                return contentDisposition + "_" + String.valueOf(UUID.randomUUID()) + UniversalAttachmentExtractor.getFileExtension(bp);
            }
            return String.valueOf(UUID.randomUUID()) + UniversalAttachmentExtractor.getFileExtension(bp);
        }
        catch (MessagingException ex) {
            return String.valueOf(UUID.randomUUID()) + UniversalAttachmentExtractor.getFileExtension(bp);
        }
    }

    private static String getFileExtension(BodyPart bp) throws MessagingException {
        String contentType = bp.getContentType();
        try {
            MimeType mime = MIME_TYPES.forName(contentType.split(";")[0].trim());
            if (mime.getExtension().isEmpty()) {
                return ".bin";
            }
            return mime.getExtension();
        }
        catch (MimeTypeException e) {
            return ".bin";
        }
    }
}

