/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.index;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.index.AbstractIndex;
import de.lwsystems.mailarchive.archive.index.LuceneIndexWriter;
import de.lwsystems.mailarchive.archive.index.LuceneUtils;
import de.lwsystems.mailarchive.archive.index.ObservedDocument;
import de.lwsystems.mailarchive.config.IIndexConfig;
import de.lwsystems.mailarchive.config.LuceneIndexConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.DocumentListener;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class LuceneIndex
extends AbstractIndex {
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class);
    private boolean debugEnabled = LOGGER.isDebugEnabled();
    public static final Version STANDARDVERSION = Version.LUCENE_33;
    private final boolean readOnly;
    private final Version version;
    private LuceneIndexWriter LuceneIndexWriter;
    private final Directory directory;

    public LuceneIndex(IBoxHolder boxHolder, String directory) throws ArchiveException, IOException {
        this(boxHolder, directory, true);
    }

    public LuceneIndex(IBoxHolder boxHolder, String directory, boolean readOnly) throws ArchiveException, IOException {
        this(boxHolder, new File(directory), STANDARDVERSION, readOnly);
    }

    public LuceneIndex(IBoxHolder boxHolder, String directory, Version version, boolean readOnly) throws ArchiveException, IOException {
        this(boxHolder, new File(directory), version, readOnly);
    }

    public LuceneIndex(IBoxHolder boxHolder, File directory) throws ArchiveException, IOException {
        this(boxHolder, directory, STANDARDVERSION, true);
    }

    public LuceneIndex(IBoxHolder boxHolder, File directory, boolean readOnly) throws ArchiveException, IOException {
        this(boxHolder, directory, STANDARDVERSION, readOnly);
    }

    public LuceneIndex(IBoxHolder boxHolder, File directory, Version version, boolean readOnly) throws ArchiveException, IOException {
        super(boxHolder);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory canot be created. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.exists()) {
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory cannot be created. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.isDirectory()) {
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory is not a directory. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.canRead()) {
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory cannot be read. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!readOnly && !directory.canWrite()) {
            String username = System.getProperty("user.name");
            throw new ArchiveException(this.getBoxHolder(), "Luceneindexdirectory is not a writeable for user " + username + ". (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        try {
            this.directory = FSDirectory.open((File)directory);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Directory cannot be opened", (Throwable)ex);
            throw new ArchiveException(boxHolder, ex);
        }
        this.version = version;
        this.readOnly = readOnly;
        if (!readOnly) {
            this.LuceneIndexWriter = new LuceneIndexWriter(this, this.directory, this.version);
        }
    }

    public LuceneIndex(IBoxHolder boxHolder, LuceneIndexConfig config) throws ArchiveException, IOException {
        this(boxHolder, config.directory, config.version, boxHolder.isReadOnly());
    }

    @Override
    public IIndexConfig getConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void closeIndexWriter() throws CorruptIndexException, IOException {
        this.LuceneIndexWriter.close();
    }

    @Override
    public String getIdentifier() {
        StringBuilder idString = new StringBuilder("LuceneIndex ");
        if (this.version == null) {
            idString.append("versionless");
        } else {
            idString.append(this.version.toString());
        }
        if (this.directory != null) {
            idString.append(": \"").append(this.directory.toString()).append("\"");
        }
        return idString.toString();
    }

    @Override
    public void addDocument(final DocumentId mailId) throws FailedArchivingException {
        ObservedDocument document = LuceneUtils.createLuceneDocument(mailId);
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void indexingFinished() {
                mailId.getDocument().indexingFinished();
            }

            @Override
            public void indexingError(Exception ex) {
                mailId.getDocument().indexingError(ex);
            }
        });
        this.addDocument(document, mailId.getDocument());
    }

    private void addDocument(ObservedDocument document, MailDocument mail) throws FailedArchivingException {
        try {
            this.LuceneIndexWriter.addDocument(document);
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)("Cannot index message \"" + mail.toString()), (Throwable)ex);
            throw new FailedArchivingException(mail, ex);
        }
    }

    @Override
    public boolean optimize() {
        boolean successful = false;
        try {
            successful = this.LuceneIndexWriter.optimize();
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
        return successful;
    }

    @Override
    public Directory getDirectory() {
        return this.directory;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void close() {
        try {
            this.closeIndexWriter();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not shut down Lucene index", (Throwable)e);
        }
    }
}

