/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.condition;

import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.condition.AbstractContainerCondition;
import de.lwsystems.mailarchive.condition.ConditionConfigType;
import de.lwsystems.mailarchive.config.ConditionOrConfig;
import de.lwsystems.mailarchive.config.IConditionConfig;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import java.util.ArrayList;

@ConditionConfigType(value=IConditionConfig.ConditionType.OR)
public class OrCondition
extends AbstractContainerCondition {
    public OrCondition(ConditionOrConfig config) {
        super(config);
    }

    protected OrCondition(AbstractCondition[] conditions) {
        super(conditions);
    }

    @Override
    public boolean matches(MailMetaData metaData) {
        boolean bRet = false;
        for (int i = 0; !bRet && i < this.conditions.length; ++i) {
            bRet = this.conditions[i].matches(metaData);
        }
        return bRet;
    }

    @Override
    public boolean isAlwaysTrue() {
        boolean bRet = false;
        for (int i = 0; !bRet && i < this.conditions.length; ++i) {
            bRet = this.conditions[i].isAlwaysTrue();
        }
        return bRet;
    }

    @Override
    public boolean isAlwaysFalse() {
        boolean bRet = true;
        for (int i = 0; bRet && i < this.conditions.length; ++i) {
            bRet = this.conditions[i].isAlwaysFalse();
        }
        return bRet;
    }

    @Override
    public AbstractCondition optimize() {
        AbstractCondition condition = this;
        if (this.conditions.length == 1) {
            condition = this.conditions[0].optimize();
        } else {
            ArrayList<AbstractCondition> newConditions = new ArrayList<AbstractCondition>(this.conditions.length);
            for (int i = 0; i < this.conditions.length; ++i) {
                if (this.conditions[i].isAlwaysFalse()) continue;
                newConditions.add(this.conditions[i]);
            }
            condition = newConditions.size() != this.conditions.length ? new OrCondition(newConditions.toArray(new AbstractCondition[newConditions.size()])).optimize() : super.optimize();
        }
        return condition;
    }
}

