/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractFSBox;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.journal.ArchivingFailedEntry;
import de.lwsystems.mailarchive.archive.journal.DuplicateDocumentEntry;
import de.lwsystems.mailarchive.archive.journal.SuccessfullyArchivedEntry;
import de.lwsystems.mailarchive.config.FSJournalConfig;
import de.lwsystems.mailarchive.config.IFSBoxConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractFSMailBox
extends AbstractFSBox {
    private static final Logger LOGGER = Logger.getLogger(AbstractFSMailBox.class);

    protected AbstractFSMailBox(IBoxHolder boxHolder, String identifier, File repositoryDirectory, int subdirs, int dirLength, IBox.CompressionType compression) throws ArchiveException {
        super(boxHolder, identifier, repositoryDirectory, subdirs, dirLength, compression);
    }

    protected AbstractFSMailBox(IBoxHolder boxHolder, String identifier, File repositoryDirectory, FSJournalConfig journal, int subdirs, int dirLength, IBox.CompressionType compression) throws ArchiveException {
        super(boxHolder, identifier, repositoryDirectory, journal, subdirs, dirLength, compression);
    }

    protected AbstractFSMailBox(IBoxHolder boxHolder, IFSBoxConfig config, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, readOnly);
    }

    protected AbstractFSMailBox(IBoxHolder boxHolder, IFSBoxConfig config, String identifier, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, identifier, readOnly);
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        int duplicateId;
        DocumentId documentId;
        block12: {
            final String fileBase = this.getFileBaseForId(document.getMetaData());
            final String mailSuffix = ".mail" + this.getCompressionSuffix();
            String metaSuffix = ".meta" + this.getCompressionSuffix();
            File fileBaseFile = new File(fileBase);
            File directory = fileBaseFile.getParentFile();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!directory.exists()) {
                throw new FailedArchivingException(document, "Directory \"" + directory.getAbsolutePath() + "\" cound not be created");
            }
            File[] previousMails = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().startsWith(fileBase) && pathname.getName().endsWith(mailSuffix);
                }
            });
            documentId = null;
            if (previousMails != null) {
                for (File previousMail : previousMails) {
                    try {
                        if (!document.equals(AbstractFSMailBox.getInStream(previousMail))) continue;
                        this.getJournal().addEntry(new DuplicateDocumentEntry(document, previousMail.getAbsolutePath().replace(this.getRepositoryDirectory().getAbsolutePath() + File.separator, "")));
                        throw new NonFailingArchivingException(document, "Duplicate of \"" + previousMail.getAbsolutePath().replace(this.getRepositoryDirectory().getAbsolutePath() + File.separator, "") + "\"");
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.info((Object)"Directory listed mailfile vanished", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        LOGGER.info((Object)"Directory listed mailfile not readable", (Throwable)ex);
                    }
                }
                duplicateId = 0;
                File mailFile = new File(fileBaseFile + ConversionUtil.fromIntToHex(duplicateId) + mailSuffix);
                File metaFile = new File(fileBaseFile + ConversionUtil.fromIntToHex(duplicateId) + metaSuffix);
                while (mailFile.exists() || metaFile.exists()) {
                    mailFile = new File(fileBaseFile + ConversionUtil.fromIntToHex(++duplicateId) + mailSuffix);
                    metaFile = new File(fileBaseFile + ConversionUtil.fromIntToHex(duplicateId) + metaSuffix);
                }
                try {
                    document.saveMail(AbstractFSMailBox.getOutStream(mailFile));
                    try {
                        document.saveMeta(AbstractFSMailBox.getOutStream(metaFile));
                        break block12;
                    }
                    catch (IOException ex) {
                        this.getJournal().addEntry(new ArchivingFailedEntry(document, ex));
                        LOGGER.fatal((Object)"Error writing metadata to archive", (Throwable)ex);
                        mailFile.delete();
                        throw new FailedArchivingException(document, "Error writing metadata to archive", ex);
                    }
                }
                catch (IOException ex) {
                    this.getJournal().addEntry(new ArchivingFailedEntry(document, ex));
                    LOGGER.fatal((Object)"Error writing mail to archive", (Throwable)ex);
                    throw new FailedArchivingException(document, "Error writing mail to archive", ex);
                }
            }
            throw new FailedArchivingException(document, "Files is null for directory \"" + directory.getAbsolutePath() + "\"");
        }
        documentId = new DocumentId(this.getBoxHolder(), document, duplicateId);
        this.getJournal().addEntry(new SuccessfullyArchivedEntry(documentId));
        return documentId;
    }
}

