/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive;

import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.IArchiveGenerator;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentity;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentityService;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.config.IArchiveGeneratorConfig;
import de.lwsystems.mailarchive.config.IBennoConfig;
import de.lwsystems.mailarchive.mailservice.IMailService;
import de.lwsystems.mailarchive.mailservice.IMailServiceHost;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.springframework.context.ApplicationContext;

public final class Benno {
    public static final String BENNNOVERSION = "2.1.6-SNAPSHOT";
    private static final Logger LOGGER = Logger.getLogger(Benno.class);
    private static final int LOGCONFIGWATCHPERIOD = 60000;
    private final IMailServiceHost serviceHost;
    private final ApplicationContext context;
    private IArchiveGenerator archiveGenerator;
    private BennoConfig config;

    public static Persister getPersister() {
        return new Persister((Strategy)new TreeStrategy("type", "count"));
    }

    public static void configureLogging() throws FactoryConfigurationError {
        String logConfigName = "log4j.xml";
        if (System.getProperty("log4j.configuration") == null) {
            if (new File("/etc/benno/bennocore-log4j.xml").exists()) {
                logConfigName = "/etc/benno/bennocore-log4j.xml";
                DOMConfigurator.configureAndWatch((String)logConfigName, (long)60000L);
            }
        } else {
            logConfigName = System.getProperty("log4j.configuration");
            DOMConfigurator.configureAndWatch((String)logConfigName, (long)60000L);
        }
        if (System.getProperty("log4j.configuration") == null) {
            URL url = ClassLoader.getSystemResource("log4j.xml");
            DOMConfigurator.configure((URL)url);
        }
    }

    public Benno(BennoConfig config, boolean readOnly, IMailServiceHost serviceHost, ApplicationContext context) throws Exception {
        this.serviceHost = serviceHost;
        this.context = context;
        this.config = config;
        if (config == null) {
            throw new Exception("no configuration");
        }
        this.archiveGenerator = this.createArchiveGenerator(config.getArchiveGenerator(), readOnly);
    }

    private IArchiveGenerator createArchiveGenerator(IArchiveGeneratorConfig archiveGeneratorConfig, boolean readOnly) throws IOException {
        return new ConfiguredArchiveGenerator(this, archiveGeneratorConfig, readOnly);
    }

    public void configure(IBennoConfig config) {
    }

    public void listArchives(PrintWriter out) {
        for (IArchive archive : this.getArchives()) {
            out.print(archive.toString());
            out.print(": ");
            out.println(archive.getState());
        }
    }

    public Iterable<IArchive> getArchives() {
        return this.archiveGenerator.getArchives();
    }

    public void optimizeIndex(String archivename, PrintWriter out) {
        try {
            IArchive archive = this.archiveGenerator.getArchive(archivename);
            if (archive != null) {
                if (archive.optimizeIndex()) {
                    out.println("Archive " + archivename + " index optimized");
                } else {
                    out.println("Archive " + archivename + " index not optimized");
                }
            }
        }
        catch (ArchiveNotFoundException ex) {
            out.println("Archive " + archivename + " not found");
        }
        catch (UnsupportedOperationException ex) {
            out.println("Archive " + archivename + " optimize repository not supported!");
        }
    }

    public IMailService registerService(IMailService service) {
        service = this.serviceHost != null ? this.serviceHost.registerService(service) : null;
        return service;
    }

    public String getIdentifier() {
        return this.archiveGenerator.getIdentifier();
    }

    public IBennoUserIdentity loadUser(IBennoUserIdentityService identityService, String username) {
        return this.archiveGenerator.loadUser(identityService, username);
    }

    public BennoConfig getConfig() {
        return this.config;
    }

    public ApplicationContext getContext() {
        return this.context;
    }
}

