/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.index.LuceneIndex;
import de.lwsystems.mailarchive.index.ObservedDocument;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

public class LuceneIndexWriter {
    private static final Logger LOGGER = Logger.getLogger(LuceneIndexWriter.class);
    private boolean debugEnabled = LOGGER.isDebugEnabled();
    private IndexWriter indexWriter;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private volatile boolean shutdown = false;
    private Future<?> commitFuture;

    public LuceneIndexWriter(LuceneIndex luceneIndex, Directory directory, Version version) throws IOException {
        try {
            IndexWriterConfig config = new IndexWriterConfig(version, (Analyzer)new ClassicAnalyzer(version));
            config.setRAMBufferSizeMB(16.0);
            config.setMaxBufferedDocs(1000);
            this.indexWriter = new NotifyingIndexWriter(directory, config);
            this.commitFuture = Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (LuceneIndexWriter.this.shutdown) {
                            return;
                        }
                        try {
                            LuceneIndexWriter.this.indexWriter.commit();
                        }
                        catch (CorruptIndexException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        catch (CorruptIndexException ex) {
            LOGGER.error((Object)"Corrupt index error opening indexwriter", (Throwable)ex);
            throw ex;
        }
        catch (LockObtainFailedException ex) {
            LOGGER.info((Object)"Lock Obtain error opening indexwriter", (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            LOGGER.error((Object)"IOError opening indexwriter", (Throwable)ex);
            throw ex;
        }
    }

    public void addDocument(final ObservedDocument document) throws Exception {
        Future<Void> f = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LuceneIndexWriter.this.indexWriter.updateDocument(new Term("id", document.getDocument().get("id")), document.getDocument());
                document.onIndexingFinished();
                return null;
            }
        });
        f.get(120L, TimeUnit.SECONDS);
    }

    public boolean optimize() throws IOException {
        boolean successful = false;
        return successful;
    }

    public void close() throws CorruptIndexException, IOException {
        if (this.debugEnabled) {
            LOGGER.debug((Object)"shutting down the index writer");
        }
        this.shutdown = true;
        this.commitFuture.cancel(true);
        this.executor.shutdownNow();
        this.indexWriter.close();
        if (this.debugEnabled) {
            LOGGER.debug((Object)"... done 'shutting down the index writer'");
        }
    }

    private static class NotifyingIndexWriter
    extends IndexWriter {
        public NotifyingIndexWriter(Directory d, IndexWriterConfig conf) throws CorruptIndexException, LockObtainFailedException, IOException {
            super(d, conf);
        }
    }
}

