/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.index.GracefulRFC882Parser;
import de.lwsystems.mailarchive.index.ObservedDocument;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.utils.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.james.mime4j.io.EOLConvertingInputStream;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParsingReader;

public class LuceneUtils {
    private static final Logger LOGGER = Logger.getLogger(LuceneUtils.class);
    private static final String UNINDEXEDHEADERS = "FROM:TO:CC:BCC:SUBJECT:DATE:CONTENT-TYPE:CONTENT-TRANSFER-ENCODING:MIME-VERSION";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.ROOT);
    private static final DateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT);

    public static ObservedDocument createLuceneDocument(Benno benno, DocumentId mailId) {
        Document document = new Document();
        document.add((Fieldable)new Field("id", mailId.getFullDocumentId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        MailMetaData metaData = mailId.getDocument().getMetaData();
        document.add((Fieldable)new Field("IndexTS", tsFormat.format(Clock.getProvider().newDate()).toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new NumericField("Date", Field.Store.YES, true).setLongValue(Long.parseLong(dateFormat.format(metaData.getDate()))));
        document.add((Fieldable)new Field("SortableDate", dateFormat.format(metaData.getDate()).toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new NumericField("Size", Field.Store.YES, false).setIntValue(metaData.getSize()));
        String[] tempArray = metaData.getSenders();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFroms();
        }
        LuceneUtils.addStrings(document, tempArray, "Sender", true);
        tempArray = metaData.getSenderDomains();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFromDomains();
        }
        LuceneUtils.addStrings(document, tempArray, "SenderDomain", true);
        tempArray = metaData.getRecipients();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFroms();
        }
        LuceneUtils.addStrings(document, tempArray, "Recipient", true);
        tempArray = metaData.getRecipientDomains();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getToDomains();
        }
        if (!metaData.isAttached()) {
            document.add((Fieldable)new Field("hasAttachment", "0", Field.Store.YES, Field.Index.NOT_ANALYZED));
        } else {
            document.add((Fieldable)new Field("hasAttachment", "1", Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        LuceneUtils.addStrings(document, tempArray, "RecipientDomain", false);
        LuceneUtils.addStrings(document, metaData.getFroms(), "From", true);
        LuceneUtils.addStrings(document, metaData.getFromDomains(), "FromDomain", false);
        LuceneUtils.addStrings(document, metaData.getTos(), "To", true);
        LuceneUtils.addStrings(document, metaData.getToDomains(), "ToDomain", false);
        LuceneUtils.addStrings(document, metaData.getCcs(), "Cc", true);
        LuceneUtils.addStrings(document, metaData.getCcDomains(), "CcDomain", false);
        LuceneUtils.addHeaders(document, metaData.getHeaders());
        LuceneUtils.addTikaField(benno, document, "Text", mailId.getDocument().getMailStream());
        return new ObservedDocument(document);
    }

    private static void addTikaField(Benno benno, Document document, String fieldname, InputStream inStream) {
        try {
            EOLConvertingInputStream stream = new EOLConvertingInputStream(inStream);
            document.add((Fieldable)new Field(fieldname, (Reader)new ParsingReader((Parser)new GracefulRFC882Parser(benno, document), (InputStream)stream, new Metadata(), new ParseContext()), Field.TermVector.NO));
        }
        catch (IOException ex) {
            LOGGER.warn((Object)ex);
        }
    }

    private static void addHeaders(Document document, Header[] headers) {
        if (headers != null) {
            for (Header header : headers) {
                String name = header.getName().toUpperCase();
                if (UNINDEXEDHEADERS.indexOf(name) == -1) {
                    document.add((Fieldable)new Field("HEADER-" + name, header.getBody(), Field.Store.NO, Field.Index.ANALYZED));
                    continue;
                }
                if (!name.equals("SUBJECT")) continue;
                document.add((Fieldable)new Field("Subject", header.getBody(), Field.Store.YES, Field.Index.ANALYZED));
                document.add((Fieldable)new Field("SortableSubject", header.getBody(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
    }

    private static void addStrings(Document document, String[] tempArray, String fieldname, boolean store) {
        if (tempArray != null) {
            for (String text : tempArray) {
                if (fieldname.equals("Sender") || fieldname.equals("From") || fieldname.equals("Recipient") || fieldname.equals("To") || fieldname.equals("Cc")) {
                    document.add((Fieldable)new Field(fieldname, text, store ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED));
                    continue;
                }
                document.add((Fieldable)new Field(fieldname, text, store ? Field.Store.YES : Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

