/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.PermissionDeniedException;
import de.lwsystems.mailarchive.archive.box.AbstractFSBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.journal.ArchivingFailedEntry;
import de.lwsystems.mailarchive.archive.journal.DuplicateDocumentEntry;
import de.lwsystems.mailarchive.archive.journal.SuccessfullyArchivedEntry;
import de.lwsystems.mailarchive.config.IFSBoxConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.DocumentAlreadyArchivedException;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractFSBennoBox
extends AbstractFSBox {
    private static final Logger LOGGER = Logger.getLogger(AbstractFSBennoBox.class);

    public AbstractFSBennoBox(IBoxHolder boxHolder, IFSBoxConfig config, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, readOnly);
    }

    public AbstractFSBennoBox(IBoxHolder boxHolder, IFSBoxConfig config, String identifier, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, identifier, readOnly);
    }

    private DocumentId doAddOrGetDocument(MailDocument document, boolean saveDocument) throws FailedArchivingException, NonFailingArchivingException, DocumentAlreadyArchivedException {
        String fileBase = this.getFileBaseForId(document.getMetaData());
        File fileBaseFile = new File(fileBase);
        File directory = fileBaseFile.getParentFile();
        if (!directory.exists()) {
            if (!saveDocument) {
                return null;
            }
            this.checkDirectory();
            directory.mkdirs();
        }
        if (!directory.exists()) {
            throw new FailedArchivingException(document, "Directory \"" + directory.getAbsolutePath() + "\" cound not be created");
        }
        File[] previousMails = this.getPreviousEmails(fileBase, directory);
        if (previousMails != null) {
            DocumentId documentId = null;
            this.failWhenAlreadyAdded(document, previousMails);
            int duplicateId = 0;
            File mailFile = new File(fileBaseFile + ConversionUtil.fromIntToHex(duplicateId) + this.getCompressionSuffix());
            if (!saveDocument) {
                return null;
            }
            while (mailFile.exists()) {
                mailFile = new File(fileBaseFile + ConversionUtil.fromIntToHex(++duplicateId) + this.getCompressionSuffix());
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Repository filename exists. Store document as " + fileBase + ConversionUtil.fromIntToHex(duplicateId) + this.getCompressionSuffix()));
            }
            this.saveDocument(document, mailFile);
            documentId = new DocumentId(this.getBoxHolder(), document, duplicateId);
            this.addJournalEntry(documentId);
            return documentId;
        }
        throw new FailedArchivingException(document, "Files is null for directory \"" + directory.getAbsolutePath() + "\"");
    }

    private File[] getPreviousEmails(final String fileBase, File directory) {
        return directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().startsWith(fileBase);
            }
        });
    }

    private void failWhenAlreadyAdded(MailDocument document, File[] previousMails) throws DocumentAlreadyArchivedException {
        for (File previousMail : previousMails) {
            try {
                if (!document.equalsBenno(AbstractFSBennoBox.getInStream(previousMail))) continue;
                this.getJournal().addEntry(new DuplicateDocumentEntry(document, previousMail.getAbsolutePath().replace(this.getRepositoryDirectory().getAbsolutePath() + File.separator, "")));
                throw new DocumentAlreadyArchivedException(document, "Duplicate of \"" + previousMail.getAbsolutePath().replace(this.getRepositoryDirectory().getAbsolutePath() + File.separator, "") + "\"");
            }
            catch (FileNotFoundException ex) {
                LOGGER.info((Object)"Directory listed mailfile vanished", (Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.info((Object)"Directory listed mailfile not readable", (Throwable)ex);
            }
            catch (PermissionDeniedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addJournalEntry(DocumentId documentId) {
        this.getJournal().addEntry(new SuccessfullyArchivedEntry(documentId));
    }

    private void saveDocument(MailDocument document, File mailFile) throws FailedArchivingException {
        try {
            document.saveBennoMail(AbstractFSBennoBox.getOutStream(mailFile));
        }
        catch (IOException ex) {
            this.getJournal().addEntry(new ArchivingFailedEntry(document, ex));
            LOGGER.fatal((Object)"Error writing mail to archive", (Throwable)ex);
            throw new FailedArchivingException(document, "Error writing mail to archive", ex);
        }
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException, DocumentAlreadyArchivedException {
        return this.doAddOrGetDocument(document, true);
    }

    @Override
    public DocumentId getDocument(MailDocument document) {
        try {
            return this.doAddOrGetDocument(document, false);
        }
        catch (DocumentAlreadyArchivedException e) {
            return new DocumentId(this.getBoxHolder(), e.getMail());
        }
        catch (FailedArchivingException e) {
            return null;
        }
        catch (NonFailingArchivingException e) {
            return null;
        }
    }
}

