/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.PreviousArchive;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.ConversionException;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import de.lwsystems.mailarchive.utils.ListUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;

@Root(name="metadata")
public class MailMetaData {
    private static final Logger LOGGER = Logger.getLogger(MailMetaData.class);
    private final DateFormat dateFormat;
    @Attribute(name="hash")
    private final String hash;
    private final String bennohash;
    @ElementArray(name="senders", entry="sender", data=true)
    private final String[] senderList;
    @ElementArray(name="recipients", entry="recipient", data=true)
    private final String[] recipientList;
    @ElementArray(name="from", entry="sender", data=true)
    private final String[] fromList;
    @ElementArray(name="to", entry="recipient", data=true)
    private final String[] toList;
    @ElementArray(name="cc", required=false, entry="recipient", data=true)
    private final String[] ccList;
    @ElementArray(name="headers", entry="header")
    private final Header[] headers;
    @ElementArray(name="archives", entry="archive", required=false)
    private final PreviousArchive[] archives;
    @Attribute(name="date", required=false)
    private final Date date;
    @Attribute(name="hasattachment", required=false)
    private final boolean attached;
    @Attribute(name="size", required=false)
    private final int size;
    @Attribute(name="defective", required=false)
    private final boolean defective;
    private String[] senderDomains = null;
    private String[] recipientDomains = null;
    private String[] fromDomains = null;
    private String[] toDomains = null;
    private String[] ccDomains = null;

    private static Persister getPersister() {
        return new Persister((Strategy)new TreeStrategy("type", "count"));
    }

    public void Serialize(OutputStream out) throws Exception {
        MailMetaData.getPersister().write((Object)this, out);
    }

    public MailMetaData(String hash, String bennohash, String[] senders, String[] recipients, String[] from, String[] to, String[] cc, Date date, boolean attached, int size, Header[] headers, PreviousArchive[] archives, boolean defective) {
        this.hash = hash;
        this.bennohash = bennohash;
        this.senderList = senders;
        this.recipientList = recipients;
        this.fromList = from;
        this.toList = to;
        this.ccList = cc;
        this.date = date != null ? date : Clock.getProvider().newDate();
        this.attached = attached;
        this.size = size;
        this.headers = headers;
        this.archives = archives;
        this.defective = defective;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ROOT);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String toString() {
        StringBuilder message = new StringBuilder(this.getHashHex()).append(": ");
        if (this.getFroms() != null && this.getFroms().length > 0) {
            message.append("FROM ");
            for (int i = 0; i < this.getFroms().length; ++i) {
                message.append(this.getFroms()[i]);
                if (i >= this.getFroms().length - 1) continue;
                message.append("; ");
            }
        }
        message.append(": ");
        for (Header header : this.getHeaders()) {
            if (!header.getName().equalsIgnoreCase("subject")) continue;
            message.append(header.getBody());
        }
        return message.toString();
    }

    public byte[] getHash() {
        byte[] hashcode = null;
        try {
            hashcode = ConversionUtil.fromHexToBytes(this.hash);
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return hashcode;
    }

    public String getHashHex() {
        return this.hash;
    }

    public String getBennoHashHex() {
        return this.getBennohash();
    }

    public String getHashB64() {
        return ConversionUtil.fromBytesToB64(this.getHash());
    }

    public boolean matchSender(String mailAddress) {
        return this.matchList(mailAddress, this.getSenders());
    }

    public boolean matchRecipient(String mailAddress) {
        return this.matchList(mailAddress, this.getRecipients());
    }

    public boolean matchFrom(String mailAddress) {
        return this.matchList(mailAddress, this.getFroms());
    }

    public boolean matchTo(String mailAddress) {
        return this.matchList(mailAddress, this.getTos());
    }

    public boolean matchCc(String mailAddress) {
        return this.matchList(mailAddress, this.getCcs());
    }

    public boolean matchSenderDomain(String domain) {
        return this.matchList(domain, this.getSenderDomains());
    }

    public boolean matchRecipientDomain(String domain) {
        return this.matchList(domain, this.getRecipientDomains());
    }

    public boolean matchFromDomain(String domain) {
        return this.matchList(domain, this.getFromDomains());
    }

    public boolean matchToDomain(String domain) {
        return this.matchList(domain, this.getToDomains());
    }

    public boolean matchCcDomain(String domain) {
        return this.matchList(domain, this.getCcDomains());
    }

    private boolean matchList(String single, String[] list) {
        boolean bRet = false;
        for (int i = 0; !bRet && i < list.length; ++i) {
            bRet = bRet || list[i].equalsIgnoreCase(single);
        }
        return bRet;
    }

    public synchronized String[] getSenderDomains() {
        if (this.senderDomains == null) {
            this.senderDomains = ListUtil.extractDomains(this.getSenders());
        }
        return this.senderDomains;
    }

    public synchronized String[] getRecipientDomains() {
        if (this.recipientDomains == null) {
            this.recipientDomains = ListUtil.extractDomains(this.getRecipients());
        }
        return this.recipientDomains;
    }

    public synchronized boolean hasAttachment() {
        return this.attached;
    }

    public synchronized String[] getFromDomains() {
        if (this.fromDomains == null) {
            this.fromDomains = ListUtil.extractDomains(this.getFroms());
        }
        return this.fromDomains;
    }

    public synchronized String[] getToDomains() {
        if (this.toDomains == null) {
            this.toDomains = ListUtil.extractDomains(this.getTos());
        }
        return this.toDomains;
    }

    public synchronized String[] getCcDomains() {
        if (this.ccDomains == null) {
            this.ccDomains = ListUtil.extractDomains(this.getCcs());
        }
        return this.ccDomains;
    }

    public void appendBennoHeaders(OutputStream outStream) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outStream, "UTF-8");
            writer.write(this.getBennoHeaders());
            writer.flush();
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public String getBennoHeaders() {
        StringBuilder headerLines = new StringBuilder(1024);
        this.appendBennoHeaders(headerLines);
        return headerLines.toString();
    }

    public void appendBennoHeaders(StringBuilder stringBuilder) {
        if (this.getSenders() != null) {
            for (String sender : this.getSenders()) {
                stringBuilder.append("Sender: ").append(sender).append("\r\n");
            }
        }
        if (this.getRecipients() != null) {
            for (String recipient : this.getRecipients()) {
                stringBuilder.append("Recipient: ").append(recipient).append("\r\n");
            }
        }
        if (this.getPreviousArchives() != null) {
            for (PreviousArchive archive : this.getPreviousArchives()) {
                archive.appendHeaderlines(stringBuilder);
            }
        }
        if (this.isDefective()) {
            stringBuilder.append("Defective: YES").append("\r\n");
        }
        if (this.isAttached()) {
            stringBuilder.append("Attachments: YES").append("\r\n");
        }
        if (this.getSize() > 0) {
            stringBuilder.append("Size: ").append(this.getSize()).append("\r\n");
        }
        stringBuilder.append("Date: ").append(this.dateFormat.format(this.getDate())).append("\r\n");
        stringBuilder.append("===== Hash: ").append(this.getHashHex()).append("\r\n");
    }

    public boolean hashesMatch() {
        return this.getBennohash().equalsIgnoreCase(this.getHashHex());
    }

    public String getBennohash() {
        return this.bennohash;
    }

    public String[] getSenders() {
        return this.senderList;
    }

    public String[] getRecipients() {
        return this.recipientList;
    }

    public String[] getFroms() {
        return this.fromList;
    }

    public String[] getTos() {
        return this.toList;
    }

    public String[] getCcs() {
        return this.ccList;
    }

    public PreviousArchive[] getPreviousArchives() {
        return this.archives;
    }

    public boolean isDefective() {
        return this.defective;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public int getSize() {
        return this.size;
    }
}

