/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.AbstractMapArchiveGenerator;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.SimpleArchive;
import de.lwsystems.mailarchive.archive.container.ContainerArchive;
import de.lwsystems.mailarchive.config.IArchiveConfig;
import de.lwsystems.mailarchive.config.IArchiveGeneratorConfig;
import de.lwsystems.mailarchive.config.IContainerArchiveConfig;
import de.lwsystems.mailarchive.config.ISimpleArchiveConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ConfiguredArchiveGenerator
extends AbstractMapArchiveGenerator {
    private static final Logger LOGGER = Logger.getLogger(ConfiguredArchiveGenerator.class);
    private final boolean readOnly;

    public ConfiguredArchiveGenerator(Benno benno, IArchiveGeneratorConfig config, boolean readOnly) {
        super(benno);
        this.readOnly = readOnly;
        this.updateArchives(config, readOnly);
    }

    private void updateArchives(IArchiveGeneratorConfig config, boolean readOnly) {
        HashSet<String> unconfiguredArchives = new HashSet<String>();
        unconfiguredArchives.addAll(this.getArchiveMap().keySet());
        for (IArchiveConfig iArchiveConfig : config.getArchives()) {
            try {
                String identifier = iArchiveConfig.getIdentifier();
                if (this.getArchiveMap().containsKey(identifier)) {
                    unconfiguredArchives.remove(identifier);
                    IArchive archive = this.getArchiveMap().get(identifier);
                    archive.configure(iArchiveConfig);
                    continue;
                }
                this.addArchive(identifier, this.getArchive(iArchiveConfig, this.getBenno(), readOnly));
            }
            catch (ArchiveException ex) {
                LOGGER.error((Object)ex);
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex);
                throw new RuntimeException(ex);
            }
        }
        for (String string : unconfiguredArchives) {
            IArchive archive = this.getArchiveMap().get(string);
            archive.close();
            this.removeArchive(string);
        }
    }

    private IArchive getArchive(IArchiveConfig archiveConfig, Benno benno, boolean readOnly) throws ArchiveException, IOException {
        if (archiveConfig instanceof IContainerArchiveConfig) {
            IContainerArchiveConfig containerArchiveConfig = (IContainerArchiveConfig)archiveConfig;
            return new ContainerArchive(benno, containerArchiveConfig, readOnly);
        }
        if (archiveConfig instanceof ISimpleArchiveConfig) {
            ISimpleArchiveConfig simpleArchiveConfig = (ISimpleArchiveConfig)archiveConfig;
            return new SimpleArchive(benno, simpleArchiveConfig, readOnly);
        }
        throw new RuntimeException("bad configuration");
    }

    @Override
    public boolean doesMatch(MailDocument document) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean updateIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rebuildIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkIntegrity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkConsistency() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean optimizeIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean optimizeRepository() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void configure(IArchiveGeneratorConfig config) {
        this.updateArchives(config, this.readOnly);
    }

    @Override
    public void addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

