/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorFactory;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IndexFactory;
import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.condition.ConditionFactory;
import de.lwsystems.mailarchive.config.AbstractContainerConfig;
import de.lwsystems.mailarchive.config.ConditionOrConfig;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.config.IBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.ISimpleContainerConfig;
import de.lwsystems.mailarchive.index.IIndex;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.maillistener.DocumentAlreadyArchivedException;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class SimpleContainer
implements IBoxHolder,
IContainer {
    private final Logger LOGGER = Logger.getLogger(SimpleContainer.class);
    private final IBoxGenerator boxGenerator;
    private final IIndex index;
    private final String identifier;
    private final IArchive archive;
    private AbstractCondition condition;
    private final boolean readOnly;

    public SimpleContainer(Benno benno, IArchive archive, ISimpleContainerConfig config, boolean readOnly) throws ArchiveException, IOException {
        this.readOnly = readOnly;
        this.boxGenerator = this.getBoxGenerator(archive, config.getBoxGenerator(), readOnly);
        this.archive = archive;
        this.condition = this.getCondition(config.getCondition());
        this.identifier = config.getIdentifier();
        this.index = IndexFactory.createIndex(benno, config.getIndex(), this, readOnly);
    }

    private AbstractCondition getCondition(ConditionOrConfig config) {
        return ConditionFactory.createCondition(config);
    }

    private IBoxGenerator getBoxGenerator(IArchive archive, IBoxGeneratorConfig iBoxGeneratorConfig, boolean readOnly) throws ArchiveException {
        return BoxGeneratorFactory.createBoxGenerator(archive, iBoxGeneratorConfig, readOnly);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public final boolean doesMatch(MailMetaData metaData) {
        return this.condition.matches(metaData);
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String getState() {
        return this.isReadOnly() ? ", readonly" : "";
    }

    @Override
    public final IArchive getArchive() {
        return this.archive;
    }

    public final IContainer getContainer() {
        return this;
    }

    public IIndex getIndex() {
        return this.index;
    }

    @Override
    public boolean optimizeIndex() {
        return this.getIndex().optimize();
    }

    @Override
    public void configure(AbstractContainerConfig container) throws ConfigurationException {
        if (!(container instanceof ISimpleContainerConfig)) {
            throw new ConfigurationException(this.getBox().getBoxHolder(), "wrong type of configuration for container " + this.getIdentifier());
        }
        ISimpleContainerConfig containerConfig = (ISimpleContainerConfig)((Object)container);
        this.boxGenerator.configure(containerConfig.getBoxGenerator());
        this.index.configure(containerConfig.getIndex());
    }

    @Override
    public Directory getIndexPath() {
        return this.getIndex().getDirectory();
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId documentId;
        if (this.doesMatch(document.getMetaData())) {
            try {
                documentId = this.boxGenerator.addDocument(document);
            }
            catch (DocumentAlreadyArchivedException e) {
                documentId = this.boxGenerator.getDocument(document);
                this.LOGGER.warn((Object)("Document is already archived and will only be reindexed: " + documentId.getFullDocumentId()));
            }
        } else {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        this.getIndex().addDocument(documentId);
        return documentId;
    }

    @Override
    public void close() {
        this.getIndex().close();
    }

    public String toString() {
        return this.getIdentifier() + " SimpleArchive";
    }

    @Override
    public IBox getBox() {
        return this.boxGenerator.getState().getActualBox();
    }

    @Override
    public Version getIndexVersion() {
        return this.getIndex().getVersion();
    }
}

