/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.AbstractBoxConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.DocumentAlreadyArchivedException;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.utils.LWBZip2CompressorInputStream;
import de.lwsystems.mailarchive.utils.LWBZip2CompressorOutputStream;
import de.lwsystems.mailarchive.utils.LWGzipCompressorInputStream;
import de.lwsystems.mailarchive.utils.LWGzipCompressorOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractBox
implements IBox {
    private final IBox.CompressionType compression;
    private final IBoxHolder boxHolder;
    private final String identifier;

    @Override
    public IBox.CompressionType getCompression() {
        return this.compression;
    }

    public static String getCompressionSuffix(IBox.CompressionType compression) {
        String suffix;
        switch (compression) {
            case gzip: {
                suffix = ".gz";
                break;
            }
            case bzip2: {
                suffix = ".bz2";
                break;
            }
            default: {
                suffix = "";
            }
        }
        return suffix;
    }

    @Override
    public String getCompressionSuffix() {
        return AbstractBox.getCompressionSuffix(this.compression);
    }

    public static OutputStream getOutStream(File file) throws FileNotFoundException, IOException {
        String filename = file.getName();
        IBox.CompressionType compression = filename.endsWith(".bz2") ? IBox.CompressionType.bzip2 : (filename.endsWith(".gz") ? IBox.CompressionType.gzip : IBox.CompressionType.none);
        return AbstractBox.getOutStream(file, compression);
    }

    public static OutputStream getOutStream(File file, IBox.CompressionType compression) throws FileNotFoundException, IOException {
        return AbstractBox.getOutStream(new FileOutputStream(file), compression);
    }

    public static OutputStream getOutStream(OutputStream stream, IBox.CompressionType compression) throws IOException {
        Object outStream;
        switch (compression) {
            case gzip: {
                outStream = new LWGzipCompressorOutputStream(stream);
                break;
            }
            case bzip2: {
                outStream = new LWBZip2CompressorOutputStream(stream);
                break;
            }
            default: {
                outStream = stream;
            }
        }
        return outStream;
    }

    public OutputStream getOutStream(OutputStream stream) throws IOException {
        return AbstractBox.getOutStream(stream, this.compression);
    }

    public static InputStream getInStream(File file) throws FileNotFoundException, IOException {
        String filename = file.getName();
        IBox.CompressionType compression = filename.endsWith(".bz2") ? IBox.CompressionType.bzip2 : (filename.endsWith(".gz") ? IBox.CompressionType.gzip : IBox.CompressionType.none);
        return AbstractBox.getInStream(file, compression);
    }

    public static InputStream getInStream(File file, IBox.CompressionType compression) throws FileNotFoundException, IOException {
        return AbstractBox.getInStream(new FileInputStream(file), compression);
    }

    public static InputStream getInStream(InputStream stream, IBox.CompressionType compression) throws IOException {
        Object inStream;
        switch (compression) {
            case gzip: {
                inStream = new LWGzipCompressorInputStream(stream);
                break;
            }
            case bzip2: {
                inStream = new LWBZip2CompressorInputStream(stream);
                break;
            }
            default: {
                inStream = stream;
            }
        }
        return inStream;
    }

    public InputStream getInStream(InputStream stream) throws IOException {
        return AbstractBox.getInStream(stream, this.compression);
    }

    public AbstractBox(IBoxHolder boxHolder, String identifier) {
        this(boxHolder, identifier, IBox.CompressionType.none);
    }

    public AbstractBox(IBoxHolder boxholder, String identifier, IBox.CompressionType compression) {
        this.boxHolder = boxholder;
        this.identifier = identifier;
        this.compression = compression;
    }

    @Override
    public IBoxHolder getBoxHolder() {
        return this.boxHolder;
    }

    @Override
    public abstract AbstractBoxConfig getConfig();

    @Override
    public final String getIdentifier() {
        return this.identifier;
    }

    @Override
    public abstract DocumentId addDocument(MailDocument var1) throws FailedArchivingException, NonFailingArchivingException, DocumentAlreadyArchivedException;

    @Override
    public abstract MailDocument getDocument(String var1);
}

