/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorState;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import org.apache.log4j.Logger;

public abstract class AbstractBoxGenerator
implements IBoxGenerator {
    private final Logger logger = Logger.getLogger(AbstractBoxGenerator.class);
    private final IBoxHolder boxHolder;
    private BoxGeneratorState state;

    protected AbstractBoxGenerator(IBoxHolder boxHolder, BoxGeneratorState state) throws ArchiveException {
        this.boxHolder = boxHolder;
        this.setState(state);
    }

    @Override
    public final IBoxHolder getBoxHolder() {
        return this.boxHolder;
    }

    @Override
    public BoxGeneratorState getState() {
        return this.state;
    }

    protected void setState(BoxGeneratorState state) throws ArchiveException {
        this.state = state;
        this.state.setReadOnly(this.boxHolder.isReadOnly());
        this.state.checkBoxes(this.boxHolder);
    }

    @Override
    public void shutdown() {
        this.getBoxHolder().close();
    }
}

