/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.AbstractBoxConfig;
import de.lwsystems.mailarchive.config.xml.FSHexBennoBoxConfig;
import de.lwsystems.mailarchive.utils.Clock;
import java.util.Date;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Root;

@Root(name="box")
public class BoxState {
    @Attribute(name="state")
    public IBox.BOXSTATE state;
    @Attribute(name="opened", required=false)
    public Date opened;
    @ElementUnion(value={@Element(name="fshexbennobox", type=FSHexBennoBoxConfig.class)})
    public AbstractBoxConfig config;

    public BoxState() {
    }

    public BoxState(AbstractBoxConfig config) {
        this.config = config;
        this.opened = Clock.getProvider().newDate();
        this.state = IBox.BOXSTATE.OPEN;
    }

    public void close() {
        this.state = IBox.BOXSTATE.CLOSED;
    }

    public IBox getBox(IBoxHolder boxHolder, boolean readOnly) throws ArchiveException {
        return this.config.getBox(boxHolder, readOnly || this.state != IBox.BOXSTATE.OPEN);
    }
}

