/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractFSBennoBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.AbstractBoxConfig;
import de.lwsystems.mailarchive.config.IFSBoxConfig;
import de.lwsystems.mailarchive.config.xml.FSHexBennoBoxConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.parser.BennoMailfileParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FSHexBennoBox
extends AbstractFSBennoBox {
    private IFSBoxConfig config;

    public FSHexBennoBox(IBoxHolder boxHolder, IFSBoxConfig config, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, readOnly);
        this.config = config;
    }

    public FSHexBennoBox(IBoxHolder boxHolder, IFSBoxConfig config, String identfier, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, identfier, readOnly);
        this.config = config;
    }

    @Override
    public String getDocumentName(MailMetaData data) {
        return data.getHashHex();
    }

    @Override
    public AbstractBoxConfig getConfig() {
        FSHexBennoBoxConfig config = new FSHexBennoBoxConfig();
        config.journal = this.config.getJournal();
        config.directory = this.config.getDirectory();
        if (!config.directory.endsWith(this.getIdentifier())) {
            config.directory = config.directory + "/" + this.getIdentifier();
        }
        config.dirLength = this.config.getDirLength();
        config.compression = this.getCompression();
        config.identifier = this.getIdentifier();
        return config;
    }

    @Override
    public MailDocument getDocument(String id) {
        id.indexOf(":");
        String myIdentifier = id.substring(0, id.indexOf(":"));
        String myId = id.substring(id.indexOf(":") + 1);
        String myPath = this.getFileBaseForId(myIdentifier, myId) + this.getCompressionSuffix();
        File mailFile = new File(myPath);
        try {
            InputStream myStream = FSHexBennoBox.getInStream(mailFile, this.getCompression());
            return new BennoMailfileParser().parseStream(myStream);
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.out);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        return null;
    }

    @Override
    public void configure(IFSBoxConfig config) {
    }
}

