/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.parser.MailfileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.ILicense;
import de.lwsystems.mailarchive.utils.LicenseException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.store.Directory;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;

public class TestUtils {
    public static DocumentId parseStream(InputStream inputStream) throws URISyntaxException, FileNotFoundException, ParserException {
        MailfileParser parser = new MailfileParser();
        MailDocument doc = parser.parseStream(inputStream);
        DocumentId docId = new DocumentId(new TestBoxHolder(), doc);
        return docId;
    }

    public static DocumentId parseFile(URI uri) throws URISyntaxException, FileNotFoundException, ParserException {
        MailfileParser parser = new MailfileParser();
        File file = new File(uri);
        MailDocument doc = parser.parseFile(file);
        DocumentId docId = new DocumentId(new TestBoxHolder(), doc);
        return docId;
    }

    public static String stackTraceToString(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        try {
            return baos.toString("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static class TestClockProvider
    implements Clock.Provider {
        private final DurationFieldType offsetType;
        private final int offsetMultiplier;

        public TestClockProvider(DurationFieldType offsetType, int offsetMultiplier) {
            this.offsetType = offsetType;
            this.offsetMultiplier = offsetMultiplier;
        }

        @Override
        public Date newDate() {
            DateTime date = new DateTime();
            return this.addOffset(date).toDate();
        }

        private DateTime addOffset(DateTime date) {
            return date.withFieldAdded(this.offsetType, this.offsetMultiplier);
        }

        @Override
        public Calendar getCalendarInstance() {
            return this.getCalendarInstance(Locale.getDefault(Locale.Category.FORMAT));
        }

        @Override
        public Calendar getCalendarInstance(Locale locale) {
            return this.newJodaDateTime().toCalendar(locale);
        }

        @Override
        public DateTime newJodaDateTime() {
            return this.addOffset(new DateTime());
        }

        @Override
        public LocalDate newLocalDate() {
            return new LocalDate((Object)new LocalDate()).withFieldAdded(this.offsetType, this.offsetMultiplier);
        }
    }

    public static class TestLicense
    implements ILicense {
        @Override
        public String getType() {
            return "Evaluation";
        }

        @Override
        public String getPlugin() {
            return "plugin";
        }

        @Override
        public String getHostInfo() throws UnknownHostException {
            return "test";
        }

        @Override
        public String getFile() {
            return "license.txt";
        }

        @Override
        public boolean checkValid(String currentHostInfo, String address) throws LicenseException {
            return true;
        }

        @Override
        public boolean checkExpire() throws LicenseException {
            return false;
        }

        @Override
        public boolean checkBuild() throws LicenseException {
            return false;
        }

        @Override
        public String getExpires() {
            return null;
        }

        @Override
        public void setExpires(String expireDate) {
        }
    }

    public static class TestBoxHolder
    implements IBoxHolder {
        @Override
        public String getIdentifier() {
            return "test";
        }

        @Override
        public IArchive getArchive() {
            return null;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public Directory getIndexPath() {
            return null;
        }

        @Override
        public void close() {
        }
    }
}

