/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.config.BennoConfig;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemContainer {
    private static final Logger LOGGER = Logger.getLogger(SystemContainer.class);
    public String systemContainerXml = "/systemcontainer.xml";

    public BennoConfig mergeSystemConfigToConfig(File config) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        Document doc2 = null;
        HashMap<String, String> ConfigXmlElements = new HashMap<String, String>();
        ConfigXmlElements.put("configuredcontainers", "simplecontainer");
        ConfigXmlElements.put("recipientheaders", "name");
        try {
            db = dbf.newDocumentBuilder();
            doc = db.parse(config);
            InputStream in = this.getClass().getResourceAsStream(this.systemContainerXml);
            doc2 = db.parse(in);
            doc = this.addDataToConfig(doc, doc2, ConfigXmlElements);
            StreamResult result = new StreamResult(new StringWriter());
            result = this.addConfigToInputStream(doc);
            try {
                BennoConfig config2 = (BennoConfig)Benno.getPersister().read(BennoConfig.class, result.getWriter().toString());
                return config2;
            }
            catch (TransformerException e) {
                return (BennoConfig)Benno.getPersister().read(BennoConfig.class, config);
            }
            catch (Exception e) {
                return (BennoConfig)Benno.getPersister().read(BennoConfig.class, config);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            LOGGER.fatal((Object)e.toString());
            return (BennoConfig)Benno.getPersister().read(BennoConfig.class, config);
        }
    }

    private Document addDataToConfig(Document bennoCustomerConfig, Document systemConfig, Map<String, String> ConfigXmlElements) {
        for (Map.Entry<String, String> cpConfigXmlElements : ConfigXmlElements.entrySet()) {
            NodeList ndListFirstFile = bennoCustomerConfig.getElementsByTagName(cpConfigXmlElements.getKey());
            Node identifier = bennoCustomerConfig.importNode(systemConfig.getElementsByTagName(cpConfigXmlElements.getValue()).item(0), true);
            ndListFirstFile.item(0).appendChild(identifier);
        }
        return bennoCustomerConfig;
    }

    private StreamResult addConfigToInputStream(Document bennoCustomerConfig) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(bennoCustomerConfig);
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            return result;
        }
        catch (TransformerException e) {
            System.err.println(e.toString());
            LOGGER.fatal((Object)e.toString());
            return null;
        }
    }
}

