/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.PermissionDeniedException;
import de.lwsystems.mailarchive.archive.RuntimeArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.journal.ArchivingFailedEntry;
import de.lwsystems.mailarchive.archive.journal.DuplicateDocumentEntry;
import de.lwsystems.mailarchive.archive.journal.IJournal;
import de.lwsystems.mailarchive.archive.journal.JournalFactory;
import de.lwsystems.mailarchive.archive.journal.SuccessfullyArchivedEntry;
import de.lwsystems.mailarchive.archive.storage.BoxStorageEngine;
import de.lwsystems.mailarchive.archive.storage.IBennoStorage;
import de.lwsystems.mailarchive.config.BennoStorageConfig;
import de.lwsystems.mailarchive.config.BoxConfig;
import de.lwsystems.mailarchive.config.BoxEncryption;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.parser.BennoMailfileParser;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import de.lwsystems.mailarchive.utils.CryptoUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BennoBox
implements IBox {
    private static final Logger LOGGER = Logger.getLogger(BennoBox.class);
    private final IBoxHolder boxHolder;
    private final IJournal journal;
    private final boolean readOnly;
    private final BoxConfig config;
    private IBennoStorage storage;
    private final File directory;
    private KeyPair keyPair;

    BennoBox(IBoxHolder boxHolder, BoxConfig config, String baseDirectory, boolean readOnly) throws ArchiveException {
        File boxRepositoryDirectory;
        this.readOnly = readOnly;
        this.boxHolder = boxHolder;
        this.config = config;
        String identifier = config.getIdentifier();
        LOGGER.info((Object)("Opening Box: " + identifier + " in " + baseDirectory));
        this.directory = boxRepositoryDirectory = Paths.get(baseDirectory, identifier).toFile();
        BennoStorageConfig boxStorageConfig = config.getBoxStorageConfig();
        this.storage = BoxStorageEngine.createBoxStorage(config, boxStorageConfig, boxRepositoryDirectory, identifier);
        this.configureEncryption(config.getEncryption());
        this.journal = readOnly ? null : JournalFactory.createFSJournal(this, config.getJournalConfig(), new File(boxRepositoryDirectory + File.separator + "journal"), readOnly);
    }

    private void configureEncryption(BoxEncryption encryption) throws ConfigurationException {
        if (encryption != null) {
            try {
                this.keyPair = CryptoUtils.loadKeyPair(encryption.getPrivateKeyFile(), encryption.getPrivateKeyFilePassword());
            }
            catch (IOException e) {
                throw new ConfigurationException(this.boxHolder, e);
            }
        }
    }

    @Override
    public BoxConfig getBoxConfig() {
        return this.config;
    }

    @Override
    public String getIdentifier() {
        return this.config.getIdentifier();
    }

    @Override
    public IBoxHolder getBoxHolder() {
        return this.boxHolder;
    }

    @Override
    public ArchivedMailDocument addDocument(MailDocument document) throws FailedArchivingException {
        MailDocumentId[] sameHashConflicts;
        for (MailDocumentId previousMailId : sameHashConflicts = this.getSameHashConflicts(document)) {
            try {
                if (!document.equalsBenno(this.getInputStream(previousMailId))) continue;
                this.getJournal().addEntry(new DuplicateDocumentEntry(document, previousMailId.toString()));
                LOGGER.warn((Object)("Document is already archived: " + previousMailId.toString()));
                return new ArchivedMailDocument(document, previousMailId);
            }
            catch (FileNotFoundException ex) {
                LOGGER.info((Object)"Directory listed mailfile vanished", (Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.info((Object)"Directory listed mailfile not readable", (Throwable)ex);
            }
            catch (PermissionDeniedException e) {
                throw new RuntimeException(e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        int sameHashDuplicateNumber = sameHashConflicts.length > 0 ? sameHashConflicts.length : 0;
        MailDocumentId documentId = this.createMailDocumentId(document, sameHashDuplicateNumber);
        this.saveDocument(document, documentId);
        ArchivedMailDocument archivedMailDocument = new ArchivedMailDocument(document, documentId);
        this.addJournalEntry(archivedMailDocument);
        return archivedMailDocument;
    }

    private MailDocumentId[] getSameHashConflicts(MailDocument document) {
        int duplicateId = 0;
        ArrayList<MailDocumentId> ids = new ArrayList<MailDocumentId>();
        while (this.storage.hasDocument(this.createMailDocumentId(document, duplicateId), this.config.getCompression())) {
            ids.add(this.createMailDocumentId(document, duplicateId));
            ++duplicateId;
        }
        return ids.toArray(new MailDocumentId[ids.size()]);
    }

    private MailDocumentId createMailDocumentId(MailDocument document, int duplicateId) {
        return new MailDocumentId(this.getIdentifier(), document.getMetaData().getHashHex(), duplicateId);
    }

    private void addJournalEntry(ArchivedMailDocument archivedMailDocument) {
        this.getJournal().addEntry(new SuccessfullyArchivedEntry(archivedMailDocument));
    }

    private void saveDocument(MailDocument document, MailDocumentId documentId) throws FailedArchivingException {
        try {
            if (this.readOnly) {
                throw new RuntimeArchiveException("Repositorydirectory \"" + this.getDirectory().getAbsolutePath() + "/" + documentId.getInternalBoxIndentifier() + "\" does not exist.");
            }
            this.storage.ensureReadyFor(document);
            OutputStream storageOutStream = this.storage.getOutStream(documentId, this.config.getCompression());
            BoxEncryption encryption = this.config.getEncryption();
            storageOutStream = CompressionUtil.getOutStream(storageOutStream, this.config.getCompression());
            if (this.keyPair != null) {
                storageOutStream = CryptoUtils.encryptStream(storageOutStream, encryption.getEngine(), this.keyPair.getPublic());
            }
            document.saveBennoMail(storageOutStream);
        }
        catch (IOException ex) {
            this.getJournal().addEntry(new ArchivingFailedEntry(document, ex));
            LOGGER.fatal((Object)"Error writing mail to archive", (Throwable)ex);
            throw new FailedArchivingException(document, "Error writing mail to archive", ex);
        }
        catch (GeneralSecurityException e) {
            LOGGER.fatal((Object)"Error writing mail to archive", (Throwable)e);
            throw new FailedArchivingException(document, "Error writing mail to archive", e);
        }
    }

    @Override
    public MailDocument getDocument(MailDocumentId id) {
        try {
            InputStream storageInStream = this.getInputStream(id);
            return new BennoMailfileParser().parseStream(storageInStream);
        }
        catch (IOException ioex) {
            LOGGER.error((Object)"BAD", (Throwable)ioex);
            ioex.printStackTrace(System.out);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"BAD", (Throwable)ex);
            ex.printStackTrace(System.out);
        }
        return null;
    }

    private InputStream getInputStream(MailDocumentId id) throws IOException, GeneralSecurityException {
        InputStream storageInStream = this.storage.getInStream(id, this.config.getCompression());
        storageInStream = CompressionUtil.getInStream(storageInStream, this.config.getCompression());
        BoxEncryption encryption = this.config.getEncryption();
        if (encryption != null) {
            storageInStream = CryptoUtils.decryptStream(storageInStream, encryption.getEngine(), this.keyPair.getPrivate());
        }
        return storageInStream;
    }

    @Override
    public String closeBox() {
        return this.journal.closeJournal();
    }

    @Override
    public IJournal getJournal() {
        return this.journal;
    }

    @Override
    public boolean exists() {
        return this.storage.exists();
    }

    protected File getDirectory() {
        return this.directory;
    }
}

