/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import com.google.common.collect.Lists;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.config.BoxConfig;
import de.lwsystems.mailarchive.config.BoxGeneratorConfig;
import de.lwsystems.mailarchive.config.ConditionMailDomainConfig;
import de.lwsystems.mailarchive.config.ConditionOrConfig;
import de.lwsystems.mailarchive.config.ContainerArchiveConfig;
import de.lwsystems.mailarchive.config.ContainerConfig;
import de.lwsystems.mailarchive.config.DirectoryWatchConfig;
import de.lwsystems.mailarchive.config.FSBoxStorageConfig;
import de.lwsystems.mailarchive.config.FSJournalConfig;
import de.lwsystems.mailarchive.config.IConditionConfig;
import de.lwsystems.mailarchive.config.LuceneIndexConfig;
import de.lwsystems.mailarchive.config.RotationInterval;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

public class SystemContainer {
    private static final Logger LOGGER = Logger.getLogger(SystemContainer.class);

    public static void addSystemContainer(BennoConfig config) {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.condition = SystemContainer.createDomainCondition();
        containerConfig.identifier = "SYSDATA";
        String systemContainerBaseDir = "/srv/benno/system/SYSDATA";
        if (System.getenv("BENNO_SYSTEM_ARCHIVE_DIR") != null) {
            systemContainerBaseDir = System.getenv("BENNO_SYSTEM_ARCHIVE_DIR");
        }
        LuceneIndexConfig indexConfig = new LuceneIndexConfig();
        indexConfig.directory = systemContainerBaseDir + File.separator + "index";
        BoxGeneratorConfig boxGenerator = new BoxGeneratorConfig();
        boxGenerator.setRotation(RotationInterval.YEARLY);
        BoxConfig boxConfig = new BoxConfig();
        FSBoxStorageConfig storageConfig = new FSBoxStorageConfig();
        storageConfig.setDriver("fs");
        storageConfig.setDirLength(2);
        storageConfig.setSubdirs(3);
        boxConfig.setBoxStorageConfig(storageConfig);
        boxConfig.setJournalConfig(new FSJournalConfig(RotationInterval.YEARLY));
        boxGenerator.boxConfigTemplate = boxConfig;
        boxGenerator.setDirectory(systemContainerBaseDir + File.separator + "repo");
        containerConfig.boxGenerator = boxGenerator;
        containerConfig.index = indexConfig;
        List<ContainerArchiveConfig> archives = config.archiveGenerator.archives;
        for (ContainerArchiveConfig archive : archives) {
            archive.containergenerator.containers.add(0, containerConfig);
            for (DirectoryWatchConfig watchConfig : archive.services) {
                watchConfig.parser.recipients.add(0, "X-BENNO-System-Recipient");
            }
        }
    }

    private static ConditionOrConfig createDomainCondition() {
        ConditionMailDomainConfig mailDomainConfig = new ConditionMailDomainConfig();
        mailDomainConfig.domain = "sys.benno-mailarchiv.de";
        mailDomainConfig.matchCc = true;
        mailDomainConfig.matchFrom = true;
        mailDomainConfig.matchSender = true;
        mailDomainConfig.matchRecipient = true;
        mailDomainConfig.matchTo = true;
        ConditionOrConfig condition = new ConditionOrConfig();
        condition.conditions = Lists.newArrayList((Object[])new IConditionConfig[]{mailDomainConfig});
        return condition;
    }
}

