/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.config.BoxEncryption;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class CryptoUtils {
    public static String createEncryptionKey(BoxEncryption.BoxEncryptionEngine engine) {
        SecretKey key = CryptoUtils.createKey(engine.getEngine(), engine.getKeySize());
        return new String(new Base64().encode(key.getEncoded()));
    }

    public static InputStream encryptStream(InputStream in, BoxEncryption.BoxEncryptionEngine engine, PublicKey publicKey) throws GeneralSecurityException, IOException, CMSException {
        byte[] ivByte = CryptoUtils.randomBytes(16);
        byte[] key = CryptoUtils.randomBytes(32);
        byte[] stringToEncrypt = CryptoUtils.concat(key, ivByte);
        byte[] encryptedData = CryptoUtils.encrypt(stringToEncrypt, publicKey);
        Cipher encryptCipher = CryptoUtils.makeCipher(engine, ivByte, key, 1);
        List<InputStream> streams = Arrays.asList(new ByteArrayInputStream(encryptedData), new CipherInputStream(in, encryptCipher));
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public static CipherOutputStream encryptStream(OutputStream out, BoxEncryption.BoxEncryptionEngine engine, PublicKey publicKey) throws GeneralSecurityException, IOException {
        byte[] ivByte = CryptoUtils.randomBytes(16);
        byte[] key = CryptoUtils.randomBytes(32);
        byte[] stringToEncrypt = CryptoUtils.concat(key, ivByte);
        byte[] encryptedData = CryptoUtils.encrypt(stringToEncrypt, publicKey);
        Cipher encryptCipher = CryptoUtils.makeCipher(engine, ivByte, key, 1);
        out.write(encryptedData);
        return new CipherOutputStream(out, encryptCipher);
    }

    private static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    private static byte[] randomBytes(int size) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[size];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    public static CipherInputStream decryptStream(InputStream in, BoxEncryption.BoxEncryptionEngine engine, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        byte[] encryptedKeyAndIv = new byte[256];
        int read = in.read(encryptedKeyAndIv);
        if (read != 256) {
            throw new IllegalArgumentException();
        }
        Cipher cipher = CryptoUtils.makeSymetricDecryptCipher(engine, privateKey, encryptedKeyAndIv);
        return new CipherInputStream(in, cipher);
    }

    private static Cipher makeSymetricDecryptCipher(BoxEncryption.BoxEncryptionEngine engine, PrivateKey privateKey, byte[] encryptedKeyAndIv) throws IOException, GeneralSecurityException {
        byte[] rawData = CryptoUtils.decrypt(encryptedKeyAndIv, privateKey);
        byte[] ivByte = new byte[16];
        System.arraycopy(rawData, 32, ivByte, 0, 16);
        byte[] key = new byte[32];
        System.arraycopy(rawData, 0, key, 0, 32);
        return CryptoUtils.makeCipher(engine, ivByte, key, 2);
    }

    private static Cipher makeCipher(BoxEncryption.BoxEncryptionEngine engine, byte[] ivByte, byte[] key, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(engine.getCipher());
        IvParameterSpec ivParamsSpec = new IvParameterSpec(ivByte);
        cipher.init(mode, CryptoUtils.keyFromString(engine, key), ivParamsSpec);
        return cipher;
    }

    public static byte[] encrypt(byte[] rawText, PublicKey publicKey) throws IOException, GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return cipher.doFinal(rawText);
    }

    public static byte[] decrypt(byte[] cipherText, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return cipher.doFinal(cipherText);
    }

    private static Key keyFromString(BoxEncryption.BoxEncryptionEngine engine, byte[] key) {
        return new SecretKeySpec(key, 0, key.length, engine.getEngine());
    }

    private static SecretKey createKey(String engine, int keySize) {
        KeyGenerator kgen;
        try {
            kgen = KeyGenerator.getInstance(engine);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SecureRandom rand = new SecureRandom();
        kgen.init(keySize, rand);
        return kgen.generateKey();
    }

    public static KeyPair loadKeyPair(String privateKeyFile, String privateKeyFilePassword) throws IOException {
        return CryptoUtils.loadKeyPair(new FileReader(privateKeyFile), privateKeyFilePassword);
    }

    private static KeyPair loadKeyPair(Reader reader, String password) throws IOException {
        KeyPair kp;
        PEMParser pemParser = new PEMParser(reader);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        Object object = pemParser.readObject();
        if (object instanceof PEMEncryptedKeyPair) {
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
            kp = converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv));
        } else {
            kp = converter.getKeyPair((PEMKeyPair)object);
        }
        return kp;
    }
}

