/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.storage;

import de.lwsystems.mailarchive.archive.RuntimeArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.storage.IBennoStorage;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class FSBoxStorage
implements IBennoStorage {
    private static final Logger LOGGER = Logger.getLogger(FSBoxStorage.class);
    private final File repositoryDirectory;
    private final int dirLength;
    private final int subdirs;
    private final String nameSuffix;

    public FSBoxStorage(int dirLength, File repositoryDirectory, int subdirs, String nameSuffix) {
        this.repositoryDirectory = repositoryDirectory;
        this.dirLength = dirLength;
        this.subdirs = subdirs;
        this.nameSuffix = nameSuffix;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public void ensureReadyFor(MailDocument document) throws FailedArchivingException {
        String fileBase = this.getFileBaseForId(document.getMetaData());
        File fileBaseFile = new File(fileBase);
        File directory = fileBaseFile.getParentFile();
        this.checkDirectory();
        directory.mkdirs();
        if (!directory.exists()) {
            throw new FailedArchivingException(document, "Directory \"" + directory.getAbsolutePath() + "\" cound not be created");
        }
    }

    private String getFileBaseForId(MailMetaData data) {
        String hashHex = data.getHashHex();
        return this.getFileBaseForHashHex(hashHex);
    }

    private String getFileBaseForHashHex(String idName) {
        StringBuffer fileBase = new StringBuffer(this.getRepositoryDirectory().getAbsolutePath());
        for (int i = 0; i < this.subdirs; ++i) {
            fileBase.append(File.separator).append(idName.substring(0, this.dirLength));
            idName = idName.substring(this.dirLength);
        }
        fileBase.append(File.separator).append(idName);
        return fileBase.toString();
    }

    @Override
    public OutputStream getOutStream(MailDocumentId documentId, IBox.CompressionType compType) throws FileNotFoundException, FailedArchivingException {
        String fileBaseFile = this.getFileBaseForHashHex(documentId.getHashHex());
        int duplicateId = 0;
        File mailFile = new File(fileBaseFile + ConversionUtil.fromIntToHex(duplicateId) + this.getNameSuffix());
        while (mailFile.exists()) {
            mailFile = new File(fileBaseFile + ConversionUtil.fromIntToHex(++duplicateId) + this.getNameSuffix());
        }
        LOGGER.debug((Object)("Getting output stream from " + mailFile.getAbsolutePath()));
        return new FileOutputStream(mailFile);
    }

    @Override
    public InputStream getInStream(MailDocumentId id, IBox.CompressionType compType) throws IOException {
        String myPath = this.getFileBaseForHashHex(id.getHashHex()) + id.getDuplicateIdHex() + this.getNameSuffix();
        LOGGER.debug((Object)("Getting input stream from " + myPath));
        File mailFile = new File(myPath);
        return new FileInputStream(mailFile);
    }

    @Override
    public boolean hasDocument(MailDocumentId documentId, IBox.CompressionType compType) {
        String fileBaseFile = this.getFileBaseForHashHex(documentId.getHashHex());
        File mailFile = new File(fileBaseFile + documentId.getDuplicateIdHex() + this.getNameSuffix());
        return mailFile.exists();
    }

    private void checkDirectory() {
        File repositoryDirectory = this.getRepositoryDirectory();
        String absolutePath = repositoryDirectory.getAbsolutePath();
        if (!repositoryDirectory.exists()) {
            if (!repositoryDirectory.mkdirs()) {
                throw new RuntimeArchiveException("Repositorydirectory \"" + absolutePath + "\" canot be created.");
            }
            if (!repositoryDirectory.exists()) {
                throw new RuntimeArchiveException("Repositorydirectory \"" + absolutePath + "\" canot be created.");
            }
        }
        if (!repositoryDirectory.isDirectory()) {
            throw new RuntimeArchiveException("Repositorydirectory \"" + absolutePath + "\" is not a directory.");
        }
        if (!repositoryDirectory.canWrite()) {
            throw new RuntimeArchiveException("Repositorydirectory \"" + absolutePath + "\" is not a writeable.");
        }
    }

    public Object getNameSuffix() {
        return this.nameSuffix;
    }

    public File getRepositoryDirectory() {
        return this.repositoryDirectory;
    }
}

