/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.storage;

import de.lwsystems.mailarchive.archive.storage.FSBoxStorage;
import de.lwsystems.mailarchive.archive.storage.IBennoStorage;
import de.lwsystems.mailarchive.archive.storage.IBennoStorageFactory;
import de.lwsystems.mailarchive.config.BoxConfig;
import de.lwsystems.mailarchive.config.FSBoxStorageConfig;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import java.io.File;

public class FSBennoStorageFactory
implements IBennoStorageFactory<FSBoxStorageConfig> {
    @Override
    public Class<FSBoxStorageConfig> getStorageDriver() {
        return FSBoxStorageConfig.class;
    }

    @Override
    public String getType() {
        return "fs";
    }

    @Override
    public IBennoStorage getStorage(BoxConfig config, FSBoxStorageConfig storageConfig, File boxRepositoryDirectory, String identifier) {
        return new FSBoxStorage(storageConfig.getDirLength(), boxRepositoryDirectory, storageConfig.getSubdirs(), CompressionUtil.getCompressionSuffix(config.getCompression()));
    }

    @Override
    public FSBoxStorageConfig createStorage(FSBoxStorageConfig templateBoxStorageConfig, String boxName, String bennoPath) {
        FSBoxStorageConfig config = new FSBoxStorageConfig();
        config.setSubdirs(templateBoxStorageConfig.getSubdirs());
        config.setDirLength(templateBoxStorageConfig.getDirLength());
        return config;
    }
}

