/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.parser;

import de.lwsystems.mailarchive.config.IFileParserConfig;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.TempMailMetaData;
import de.lwsystems.mailarchive.parser.AbstractStreamFileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MailDateFormat;
import org.apache.log4j.Logger;

public class BennoMailfileParser
extends AbstractStreamFileParser {
    private static final Logger LOGGER = Logger.getLogger(BennoMailfileParser.class);
    private final String[] fromHeaders;
    private final String[] toHeaders;
    private final String[] ccHeaders;

    public BennoMailfileParser() {
        this(new String[]{"FROM"}, new String[]{"TO"}, new String[]{"CC"});
    }

    public BennoMailfileParser(String[] fromHeaders, String[] toHeaders, String[] ccHeaders) {
        this.fromHeaders = fromHeaders;
        this.toHeaders = toHeaders;
        this.ccHeaders = ccHeaders;
    }

    public BennoMailfileParser(IFileParserConfig config) {
        this(config.getSenders().toArray(new String[config.getSenders().size()]), config.getRecipients().toArray(new String[config.getRecipients().size()]), config.getSecrets().toArray(new String[config.getSecrets().size()]));
    }

    private boolean isIn(String single, String[] array) {
        boolean in = false;
        if (array != null) {
            for (int i = 0; !in && i < array.length; ++i) {
                in = array[i].equalsIgnoreCase(single);
            }
        }
        return in;
    }

    private void writeMail(OutputStream mail, MessageDigest md, byte singleByte) throws IOException {
        md.update(singleByte);
        mail.write(singleByte);
    }

    private void writeMail(OutputStream mail, MessageDigest md, byte[] bytes) throws IOException {
        md.update(bytes);
        mail.write(bytes);
    }

    private boolean processHeaderLine(boolean inPreamble, TempMailMetaData tempMeta, ByteArrayOutputStream tempOutBytes, MessageDigest md, ByteArrayOutputStream tempLine) throws ParserException, UnsupportedEncodingException, IOException {
        byte[] tempInBytes = tempLine.toByteArray();
        tempLine.reset();
        if (tempInBytes.length > 0) {
            if (inPreamble) {
                Header tempHeader = new Header(tempInBytes, "UTF-8");
                if (tempHeader.getName().equals("Sender")) {
                    try {
                        tempMeta.addSender(tempHeader.getBody());
                    }
                    catch (AddressException ex) {
                        LOGGER.error((Object)ex);
                    }
                } else if (tempHeader.getName().equals("Recipient")) {
                    try {
                        tempMeta.addRecipient(tempHeader.getBody());
                    }
                    catch (AddressException ex) {
                        LOGGER.error((Object)ex);
                    }
                } else if (tempHeader.getName().equals("PreviousHash")) {
                    tempMeta.addPreviousHash(tempHeader.getBody());
                } else if (tempHeader.getName().equals("PreviousDate")) {
                    tempMeta.setPreviousDate(tempHeader.getBody());
                } else if (tempHeader.getName().equals("PreviousName")) {
                    tempMeta.setPreviousName(tempHeader.getBody());
                } else if (tempHeader.getName().equals("Defective")) {
                    tempMeta.setDefective(true);
                } else if (tempHeader.getName().equals("Attachments")) {
                    tempMeta.setAttached(true);
                } else if (tempHeader.getName().equals("Date")) {
                    tempMeta.setDate(tempHeader.getBody());
                } else if (tempHeader.getName().equals("Size")) {
                    tempMeta.setSize(tempHeader.getBody());
                } else if (tempHeader.getName().equals("CustomHash")) {
                    tempMeta.setCustomHashActive(true);
                } else if (tempHeader.getName().equals("CustomHashParameter")) {
                    tempMeta.addCustomHashParameter(tempHeader.getBody());
                } else if (tempHeader.getName().equals("StandardChecksum")) {
                    tempMeta.setStandardChecksum(tempHeader.getBody());
                } else if (tempHeader.getName().equals("===== Hash")) {
                    inPreamble = false;
                    tempMeta.setBennoHash(tempHeader.getBody());
                }
            } else {
                this.writeMail((OutputStream)tempOutBytes, md, tempInBytes);
                try {
                    Header tempHeader = new Header(tempInBytes);
                    tempMeta.addHeader(tempHeader);
                    if (this.isIn(tempHeader.getName(), this.fromHeaders)) {
                        try {
                            tempMeta.addFrom(tempHeader.getBody());
                        }
                        catch (AddressException ex) {
                            LOGGER.error((Object)ex);
                        }
                    }
                    if (this.isIn(tempHeader.getName(), this.toHeaders)) {
                        try {
                            tempMeta.addTo(tempHeader.getBody());
                        }
                        catch (AddressException ex) {
                            LOGGER.error((Object)ex);
                        }
                    }
                    if (this.isIn(tempHeader.getName(), this.ccHeaders)) {
                        try {
                            tempMeta.addCc(tempHeader.getBody());
                        }
                        catch (AddressException ex) {
                            LOGGER.error((Object)ex);
                        }
                    }
                    if (tempHeader.getName().equalsIgnoreCase("Date")) {
                        tempMeta.setDate(new MailDateFormat().parse(tempHeader.getBody()));
                    }
                    if (tempHeader.getName().equalsIgnoreCase("Content-Type")) {
                        String body = tempHeader.getBody().toLowerCase();
                        tempMeta.setAttached(body.contains("mixed"));
                    }
                }
                catch (Exception ex) {
                    tempMeta.setDefective(true);
                }
            }
        }
        return inPreamble;
    }

    @Override
    public MailDocument parseStream(InputStream stream, int length) throws ParserException {
        MailDocument document = null;
        if ((stream = new BufferedInputStream(stream)) != null) {
            try {
                TempMailMetaData tempMeta = new TempMailMetaData();
                ByteArrayOutputStream tempBytes = new ByteArrayOutputStream(length);
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                try {
                    boolean inHeader = true;
                    boolean inPreamble = true;
                    boolean receivedNewline = false;
                    boolean processLine = false;
                    ByteArrayOutputStream tempLine = new ByteArrayOutputStream(1024);
                    int tempByte = 0;
                    tempByte = stream.read();
                    block15: while (inHeader) {
                        if (tempByte == -1) {
                            inPreamble = this.processHeaderLine(inPreamble, tempMeta, tempBytes, md, tempLine);
                            inHeader = false;
                            continue;
                        }
                        if (receivedNewline) {
                            receivedNewline = false;
                            switch (tempByte) {
                                case 10: {
                                    inHeader = false;
                                    tempLine.write(tempByte);
                                    tempByte = stream.read();
                                    if (tempByte == 13) {
                                        tempLine.write(tempByte);
                                        tempByte = stream.read();
                                    }
                                    inPreamble = this.processHeaderLine(inPreamble, tempMeta, tempBytes, md, tempLine);
                                    continue block15;
                                }
                                case 13: {
                                    inHeader = false;
                                    tempLine.write(tempByte);
                                    tempByte = stream.read();
                                    if (tempByte == 10) {
                                        tempLine.write(tempByte);
                                        tempByte = stream.read();
                                    }
                                    inPreamble = this.processHeaderLine(inPreamble, tempMeta, tempBytes, md, tempLine);
                                    continue block15;
                                }
                                case 9: 
                                case 32: {
                                    tempLine.write(tempByte);
                                    tempByte = stream.read();
                                    continue block15;
                                }
                            }
                            inPreamble = this.processHeaderLine(inPreamble, tempMeta, tempBytes, md, tempLine);
                            tempLine.write(tempByte);
                            tempByte = stream.read();
                            continue;
                        }
                        switch (tempByte) {
                            case 10: {
                                receivedNewline = true;
                                tempLine.write(tempByte);
                                tempByte = stream.read();
                                if (tempByte != 13) continue block15;
                                tempLine.write(tempByte);
                                tempByte = stream.read();
                                continue block15;
                            }
                            case 13: {
                                receivedNewline = true;
                                tempLine.write(tempByte);
                                tempByte = stream.read();
                                if (tempByte != 10) continue block15;
                                tempLine.write(tempByte);
                                tempByte = stream.read();
                                continue block15;
                            }
                        }
                        tempLine.write(tempByte);
                        tempByte = stream.read();
                    }
                    while (tempByte != -1) {
                        this.writeMail((OutputStream)tempBytes, md, (byte)tempByte);
                        tempByte = stream.read();
                    }
                    String actHash = ConversionUtil.fromBytesToHex(md.digest());
                    tempMeta.setHash(actHash);
                    if (tempMeta.isCustomHashActive()) {
                        if (!actHash.equalsIgnoreCase(tempMeta.getStandardChecksum())) {
                            LOGGER.fatal((Object)("Found invalid mailfile: expected \"" + tempMeta.getBennoHash() + "\" actual \"" + actHash + "\""));
                        }
                    } else if (!actHash.equalsIgnoreCase(tempMeta.getBennoHash())) {
                        LOGGER.fatal((Object)("Found invalid mailfile: expected \"" + tempMeta.getBennoHash() + "\" actual \"" + actHash + "\""));
                    }
                    tempMeta.setSize(tempBytes.size());
                    document = new MailDocument(tempBytes.toByteArray(), tempMeta.getMailMetaData());
                }
                catch (IOException ex) {
                    LOGGER.error(null, (Throwable)ex);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.error(null, (Throwable)ex);
            }
            try {
                stream.close();
            }
            catch (IOException ex) {
                LOGGER.info((Object)ex);
            }
        }
        return document;
    }
}

