/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.utils.ConversionUtil;

public class MailDocumentId {
    private final String internalBoxIndentifier;
    private final String hashHex;
    private final String scid;
    private final int sameHashDuplicateNumber;

    public MailDocumentId(String internalBoxIndentifier, String hashHex, int sameHashDuplicateNumber, String scid) {
        this.internalBoxIndentifier = internalBoxIndentifier;
        this.hashHex = hashHex;
        this.sameHashDuplicateNumber = sameHashDuplicateNumber;
        this.scid = scid;
    }

    public MailDocumentId(String completeId, String scid) {
        int separatorIndex = completeId.indexOf(":");
        String boxInternalIdentifier = completeId.substring(0, separatorIndex);
        String fullId = completeId.substring(separatorIndex + 1);
        this.internalBoxIndentifier = boxInternalIdentifier;
        this.hashHex = fullId.substring(0, fullId.length() - 2);
        this.sameHashDuplicateNumber = ConversionUtil.fromHexToInt(fullId.substring(fullId.length() - 2));
        this.scid = scid;
    }

    public String toString() {
        return (this.internalBoxIndentifier != null && this.internalBoxIndentifier.length() > 0 ? this.internalBoxIndentifier + ":" : "") + this.hashHex + this.getDuplicateIdHex();
    }

    public String getDuplicateIdHex() {
        return ConversionUtil.fromIntToHex(this.sameHashDuplicateNumber);
    }

    public String getHashHex() {
        return this.hashHex;
    }

    public String getInternalBoxIndentifier() {
        return this.internalBoxIndentifier;
    }

    public String getScid() {
        return this.scid;
    }
}

