/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.storage;

import de.lwsystems.mailarchive.archive.storage.IBennoStorage;
import de.lwsystems.mailarchive.archive.storage.IBennoStorageFactory;
import de.lwsystems.mailarchive.config.BennoStorageConfig;
import de.lwsystems.mailarchive.config.BoxConfig;
import de.lwsystems.mailarchive.utils.PersistenceUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

public class BoxStorageEngine
implements Converter {
    private static final Logger LOGGER = Logger.getLogger(BoxStorageEngine.class);
    private static Map<String, IBennoStorageFactory> storageFactoryMap = new HashMap<String, IBennoStorageFactory>();

    public void write(OutputNode node, Object value) throws Exception {
        node.remove();
        PersistenceUtil.createPersister().write(value, node.getParent());
    }

    public Object read(InputNode node) throws Exception {
        Class<? extends BennoStorageConfig> storageConfigType = this.getStorageConfigType(node);
        return PersistenceUtil.createPersister().read(storageConfigType, node);
    }

    public static IBennoStorage createBoxStorage(BoxConfig config, BennoStorageConfig storageConfig, File boxRepositoryDirectory, String identifier) {
        IBennoStorageFactory storageFactory = storageFactoryMap.get(storageConfig.getDriver());
        return storageFactory.getStorage(config, storageConfig, boxRepositoryDirectory, identifier);
    }

    private Class<? extends BennoStorageConfig> getStorageConfigType(InputNode node) throws Exception {
        String type = node.getAttribute("driver").getValue();
        return this.getStorageConfigType(type);
    }

    private Class<? extends BennoStorageConfig> getStorageConfigType(String driver) {
        IBennoStorageFactory factory = storageFactoryMap.get(driver);
        if (factory == null) {
            String message = "Storage driver " + driver + " not found. Available drivers: " + storageFactoryMap.keySet();
            LOGGER.error((Object)message);
            throw new RuntimeException(message);
        }
        return factory.getStorageDriver();
    }

    public static BennoStorageConfig createBoxStorage(BennoStorageConfig templateBoxStorageConfig, String boxName, String bennoPath) {
        BennoStorageConfig config = storageFactoryMap.get(templateBoxStorageConfig.getDriver()).createStorage(templateBoxStorageConfig, boxName, bennoPath);
        config.setDriver(templateBoxStorageConfig.getDriver());
        return config;
    }

    static {
        ServiceLoader<IBennoStorageFactory> storageFactoryServiceLoader = ServiceLoader.load(IBennoStorageFactory.class);
        LOGGER.info((Object)"Checking available storage drivers");
        for (IBennoStorageFactory storageFactory : storageFactoryServiceLoader) {
            LOGGER.info((Object)("Found storage driver: " + storageFactory.getType()));
            storageFactoryMap.put(storageFactory.getType(), storageFactory);
        }
    }
}

