/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.AbstractArchive;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.container.ConfiguredContainerGenerator;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.config.ContainerArchiveConfig;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;

public class ContainerArchive
extends AbstractArchive {
    private final Logger LOGGER = Logger.getLogger(ContainerArchive.class);
    private final IContainerGenerator containerGenerator;

    public ContainerArchive(Benno benno, ContainerArchiveConfig config, boolean readOnly) throws ArchiveException, IOException {
        super(benno, config, config.getIdentifier(), readOnly);
        this.containerGenerator = new ConfiguredContainerGenerator(benno, this, config.getContainerGenerator(), readOnly);
    }

    @Override
    public ArchivedMailDocument addDocument(MailDocument document) throws NonFailingArchivingException, FailedArchivingException {
        if (!this.doesMatch(document.getMetaData())) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info((Object)("Email \"" + document.toString() + "\" does not match criteria of container\"" + this.containerGenerator.getArchive().getIdentifier() + "\""));
            }
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        ArchivedMailDocument archivedMailDocument = this.containerGenerator.addDocument(document);
        return archivedMailDocument;
    }

    @Override
    public RemovedMailDocument removeDocument(MailDocument document, String mode) throws ArchiveException, IOException, FailedArchivingException, NonFailingArchivingException {
        if (!this.doesMatch(document.getMetaData())) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info((Object)("Email \"" + document.toString() + "\" does not match criteria of container for remove index entry\"" + this.containerGenerator.getArchive().getIdentifier() + "\""));
            }
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria for remove index entry");
        }
        this.containerGenerator.removeDocument(document, mode);
        return null;
    }

    @Override
    public void addRemoveRepoJournalEntry(MailDocument document) throws NonFailingArchivingException, FailedArchivingException {
        if (!this.doesMatch(document.getMetaData())) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info((Object)("Email \"" + document.toString() + "\" does not match criteria of container for repolog entry\"" + this.containerGenerator.getArchive().getIdentifier() + "\""));
            }
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria for repolog entry");
        }
        this.containerGenerator.addRemoveRepoJournalEntry(document);
    }

    @Override
    public boolean optimizeIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void configure(ContainerArchiveConfig config) throws ConfigurationException {
        super.configure(config);
        if (this.containerGenerator != null) {
            this.containerGenerator.configure(config.getContainerGenerator());
        }
    }

    public String toString() {
        return this.getIdentifier() + " ContainerArchive";
    }

    @Override
    public Directory getIndexPath() {
        throw new UnsupportedOperationException("Not supported here!");
    }

    @Override
    public String getIndexPathString() {
        throw new UnsupportedOperationException("Not supported here!");
    }

    @Override
    public IContainerGenerator getContainerGenerator() {
        return this.containerGenerator;
    }

    @Override
    public void shutdown() {
        this.containerGenerator.shutdown();
    }
}

