/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.index.GracefulRFC882Parser;
import de.lwsystems.mailarchive.index.ObservedDocument;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import de.lwsystems.mailarchive.utils.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.mime4j.io.EOLConvertingInputStream;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParsingReader;

public class LuceneUtils {
    private static final Logger LOGGER = Logger.getLogger(LuceneUtils.class);
    private static final String UNINDEXEDHEADERS = "FROM:TO:CC:BCC:SUBJECT:DATE:CONTENT-TYPE:CONTENT-TRANSFER-ENCODING:MIME-VERSION";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.ROOT);
    private static final DateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT);

    public static ObservedDocument createLuceneDocument(Benno benno, ArchivedMailDocument mailId) {
        Document document = new Document();
        document.add((Fieldable)new Field("id", mailId.getFullDocumentId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        MailMetaData metaData = mailId.getDocument().getMetaData();
        document.add((Fieldable)new Field("IndexTS", tsFormat.format(Clock.getProvider().newDate()).toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new NumericField("Date", Field.Store.YES, true).setLongValue(Long.parseLong(dateFormat.format(metaData.getDate()))));
        document.add((Fieldable)new Field("SortableDate", dateFormat.format(metaData.getDate()).toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new NumericField("Size", Field.Store.YES, false).setIntValue(metaData.getSize()));
        document.add((Fieldable)new Field("scid", mailId.getDocument().getMetaData().getScid(), Field.Store.YES, Field.Index.ANALYZED));
        document.add((Fieldable)new Field("Timezone", mailId.getDocument().getMetaData().getTimezone(), Field.Store.YES, Field.Index.NO));
        String[] tempArray = metaData.getSenders();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFroms();
        }
        LuceneUtils.addStrings(document, tempArray, "Sender", true);
        tempArray = metaData.getSenderDomains();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFromDomains();
        }
        LuceneUtils.addStrings(document, tempArray, "SenderDomain", true);
        tempArray = metaData.getRecipients();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getFroms();
        }
        LuceneUtils.addStrings(document, tempArray, "Recipient", true);
        tempArray = metaData.getRecipientDomains();
        if (tempArray == null || tempArray.length == 0) {
            tempArray = metaData.getToDomains();
        }
        if (!metaData.isAttached()) {
            document.add((Fieldable)new Field("hasAttachment", "0", Field.Store.YES, Field.Index.NOT_ANALYZED));
        } else {
            Integer attachmentCount;
            try {
                attachmentCount = LuceneUtils.getAttachmentCount(mailId.getDocument().getMimeMesage());
                if (attachmentCount == 0) {
                    attachmentCount = 1;
                }
            }
            catch (ClassCastException | MessagingException e) {
                attachmentCount = 1;
            }
            document.add((Fieldable)new Field("hasAttachment", attachmentCount.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        LuceneUtils.addStrings(document, tempArray, "RecipientDomain", false);
        LuceneUtils.addStrings(document, metaData.getFroms(), "From", true);
        LuceneUtils.addStrings(document, metaData.getFromDomains(), "FromDomain", false);
        LuceneUtils.addStrings(document, metaData.getTos(), "To", true);
        LuceneUtils.addStrings(document, metaData.getToDomains(), "ToDomain", false);
        LuceneUtils.addStrings(document, metaData.getCcs(), "Cc", true);
        LuceneUtils.addStrings(document, metaData.getCcDomains(), "CcDomain", false);
        LuceneUtils.addHeaders(document, metaData.getHeaders());
        LuceneUtils.addHeaders(document, metaData.getSecretHeaders());
        LuceneUtils.addTikaField(benno, document, "Text", mailId.getDocument().getMailStream());
        return new ObservedDocument(document);
    }

    private static void addTikaField(Benno benno, Document document, String fieldname, InputStream inStream) {
        try {
            EOLConvertingInputStream stream = new EOLConvertingInputStream(inStream);
            document.add((Fieldable)new Field(fieldname, (Reader)new ParsingReader((Parser)new GracefulRFC882Parser(benno, document), (InputStream)stream, new Metadata(), new ParseContext()), Field.TermVector.NO));
        }
        catch (IOException ex) {
            LOGGER.warn((Object)ex);
        }
    }

    private static void addHeaders(Document document, Header[] headers) {
        if (headers != null) {
            for (Header header : headers) {
                String name = header.getName().toUpperCase();
                if (UNINDEXEDHEADERS.indexOf(name) == -1) {
                    document.add((Fieldable)new Field("HEADER-" + name, header.getBody(), Field.Store.NO, Field.Index.ANALYZED));
                    continue;
                }
                if (!name.equals("SUBJECT")) continue;
                document.add((Fieldable)new Field("Subject", header.getBody(), Field.Store.YES, Field.Index.ANALYZED));
                document.add((Fieldable)new Field("SortableSubject", header.getBody(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
    }

    private static void addStrings(Document document, String[] tempArray, String fieldname, boolean store) {
        if (tempArray != null) {
            for (String text : tempArray) {
                if (fieldname.equals("Sender") || fieldname.equals("From") || fieldname.equals("Recipient") || fieldname.equals("To") || fieldname.equals("Cc")) {
                    document.add((Fieldable)new Field(fieldname, text, store ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED));
                    continue;
                }
                document.add((Fieldable)new Field(fieldname, text, store ? Field.Store.YES : Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
    }

    private static int getAttachmentCount(MimeMessage mimeMessage) {
        int count = 0;
        try {
            Object object = mimeMessage.getContent();
            if (object instanceof Multipart) {
                Multipart parts = (Multipart)object;
                ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
                LuceneUtils.getBodyPartList(parts, bodyParts);
                for (int i = 0; i < bodyParts.size(); ++i) {
                    if ("inline".equalsIgnoreCase(bodyParts.get(i).getDisposition())) {
                        ++count;
                        continue;
                    }
                    if (!"attachment".equalsIgnoreCase(bodyParts.get(i).getDisposition())) continue;
                    ++count;
                }
            }
        }
        catch (IOException | MessagingException e) {
            LOGGER.debug((Object)e.toString());
        }
        return count;
    }

    public static void getBodyPartList(Multipart mp, ArrayList<BodyPart> bodyParts) throws MessagingException, IOException {
        ArrayList bodyPart = new ArrayList();
        for (int i = 0; i < mp.getCount(); ++i) {
            BodyPart bp = mp.getBodyPart(i);
            boolean isMultiPart = false;
            try {
                if (bp.getContent().getClass().equals(MimeMultipart.class)) {
                    isMultiPart = true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                isMultiPart = false;
                try {
                    bp.setHeader("Content-Type", bp.getContentType());
                }
                catch (MessagingException mex) {
                    LOGGER.error((Object)"Cannot fetch Content-Type: ", (Throwable)mex);
                    bp.setHeader("Content-Type", "application/octet-stream");
                }
                LOGGER.info((Object)("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + bp.getContentType()));
            }
            if (isMultiPart) {
                LuceneUtils.getBodyPartList((Multipart)((MimeMultipart)bp.getContent()), bodyParts);
                continue;
            }
            bodyParts.add(bp);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

