/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.index.LuceneIndex;
import de.lwsystems.mailarchive.index.ObservedDocument;
import de.lwsystems.mailarchive.log.LogClass;
import de.lwsystems.mailarchive.log.RemoveLogClass;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

public class LuceneIndexWriter {
    private static final Logger LOGGER = Logger.getLogger(LuceneIndexWriter.class);
    private boolean debugEnabled = LOGGER.isDebugEnabled();
    private IndexWriter indexWriter;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Integer indexTimeout;
    private volatile boolean shutdown = false;
    private Thread commitThread;

    public LuceneIndexWriter(LuceneIndex luceneIndex, Directory directory, Version version, Integer indexTimeout) throws IOException {
        try {
            IndexWriterConfig config = new IndexWriterConfig(version, (Analyzer)new ClassicAnalyzer(version));
            config.setRAMBufferSizeMB(16.0);
            config.setMaxBufferedDocs(1000);
            this.indexWriter = new NotifyingIndexWriter(directory, config);
            this.setIndexTimeout(indexTimeout);
            this.commitThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (LuceneIndexWriter.this.shutdown) {
                            return;
                        }
                        try {
                            LuceneIndexWriter.this.indexWriter.commit();
                            HashMap<String, LogClass> instance = RemoveLogClass.getInstanceList();
                            for (Map.Entry<String, LogClass> deleteLogFile : instance.entrySet()) {
                                LogClass deleteLogClass = deleteLogFile.getValue();
                                deleteLogClass.moveLogFile();
                            }
                            RemoveLogClass.removeAllContainerFromInstance();
                            continue;
                        }
                        catch (CorruptIndexException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        catch (NullPointerException nullPointerException) {
                            continue;
                        }
                        break;
                    }
                }
            });
            this.commitThread.start();
        }
        catch (CorruptIndexException ex) {
            LOGGER.error((Object)"Corrupt index error opening indexwriter", (Throwable)ex);
            throw ex;
        }
        catch (LockObtainFailedException ex) {
            LOGGER.fatal((Object)("Lock Obtain error opening indexwriter: " + ex.getMessage()));
            throw new RuntimeException(ex.getMessage());
        }
        catch (IOException ex) {
            LOGGER.error((Object)"IOError opening indexwriter", (Throwable)ex);
            throw ex;
        }
    }

    public void addDocument(final ObservedDocument document) throws Exception {
        Future<Void> f = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LuceneIndexWriter.this.indexWriter.updateDocument(new Term("id", document.getDocument().get("id")), document.getDocument());
                document.onIndexingFinished();
                return null;
            }
        });
        f.get(this.getIndexTimeout().intValue(), TimeUnit.SECONDS);
    }

    public void removeDocument(final ObservedDocument document, String mode) throws Exception {
        if (mode.equals("hard")) {
            Future<Void> f = this.executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Term term = new Term("id", document.getDocument().get("id"));
                    LuceneIndexWriter.this.indexWriter.deleteDocuments(term);
                    document.onRemovingFinished();
                    return null;
                }
            });
            f.get(this.getIndexTimeout().intValue(), TimeUnit.SECONDS);
        } else {
            this.addDocument(document);
        }
    }

    public boolean optimize() throws IOException {
        boolean successful = false;
        return successful;
    }

    public void close() throws CorruptIndexException, IOException {
        if (this.debugEnabled) {
            LOGGER.debug((Object)"shutting down the index writer");
        }
        this.shutdown = true;
        this.commitThread.interrupt();
        this.executor.shutdown();
        this.indexWriter.close();
        if (this.debugEnabled) {
            LOGGER.debug((Object)"... done 'shutting down the index writer'");
        }
    }

    public void setIndexTimeout(Integer indexTimeout) {
        this.indexTimeout = indexTimeout;
    }

    public Integer getIndexTimeout() {
        return this.indexTimeout;
    }

    private static class NotifyingIndexWriter
    extends IndexWriter {
        public NotifyingIndexWriter(Directory d, IndexWriterConfig conf) throws CorruptIndexException, LockObtainFailedException, IOException {
            super(d, conf);
        }
    }
}

